/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.net.url;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBuilder {
    private String domain;
    private int port = 0;
    private String protocol = "http://";
    private StringBuilder url = new StringBuilder();
    private StringBuilder parms = new StringBuilder();

    public UrlBuilder() {
    }

    public UrlBuilder(String domain) {
        this.domain = domain;
    }

    public UrlBuilder setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public UrlBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public UrlBuilder setProtocol(String protocol) {
        this.protocol = !protocol.endsWith("/") ? (!protocol.endsWith("//") ? (!protocol.endsWith("://") ? protocol + "://" : protocol + "//") : protocol + "/") : protocol;
        return this;
    }

    public UrlBuilder addSubPage(String page) {
        this.url.append(page);
        if (!page.endsWith("/")) {
            this.url.append("/");
        }
        return this;
    }

    public <T> UrlBuilder addKeyValue(String key, T value) {
        this.parms.append(key);
        this.parms.append("=");
        this.parms.append(value);
        this.parms.append("&");
        return this;
    }

    public <T> UrlBuilder addKeyValues(String key, List<T> values) {
        int size = values.size();
        int c = 0;
        this.parms.append(key);
        this.parms.append("=");
        for (T value : values) {
            this.parms.append(value);
            if (++c >= size) continue;
            this.parms.append(";");
        }
        this.parms.append("&");
        return this;
    }

    public <T> UrlBuilder addKeyValues(String key, T ... values) {
        this.parms.append(key);
        this.parms.append("=");
        int c = 0;
        for (T value : values) {
            this.parms.append(value);
            if (++c >= values.length) continue;
            this.parms.append(";");
        }
        this.parms.append("&");
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol);
        sb.append(this.domain);
        if (this.port > 0) {
            sb.append(":");
            sb.append(this.port);
        }
        sb.append("/");
        if (this.url.length() > 0) {
            sb.append((CharSequence)this.url);
        }
        if (this.parms.length() > 0) {
            sb.replace(sb.length() - 1, sb.length(), "?");
            sb.append((CharSequence)this.parms);
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getLocalComputerName() {
        String compName = null;
        if (SystemUtils.IS_OS_UNIX) {
            try {
                compName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            compName = System.getenv("COMPUTERNAME");
        }
        return compName;
    }
}

