/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.option;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option {
    public List<String> values = new ArrayList<String>();
    public String longName = "";
    public String shortName = "";
    public int arguments = 0;
    public boolean used = false;
    public boolean required = true;
    public String description = "";

    public Option(String longName, String shortName, String value) {
        this.longName = longName;
        this.shortName = shortName;
        this.values.add(value);
    }

    public Option(String longName, String shortName) {
        this.longName = longName;
        this.shortName = shortName;
    }

    public Option(String longName, String shortName, boolean required) {
        this.longName = longName;
        this.shortName = shortName;
        this.required = required;
    }

    public Option(String longName, String shortName, boolean optional, int arguments) {
        this.longName = longName;
        this.shortName = shortName;
        this.required = optional;
        this.arguments = arguments;
    }

    public Option(String longName, String shortName, boolean required, int arguments, String description) {
        this.longName = longName;
        this.shortName = shortName;
        this.required = required;
        this.arguments = arguments;
        this.description = description;
    }

    public void setUsed() {
        this.used = true;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getString() {
        return this.getString(false);
    }

    public Integer getInteger() {
        return new Integer(this.getString(false));
    }

    public String getString(boolean doSpaces) {
        StringBuffer sb = new StringBuffer();
        if (this.values.size() == 0) {
            return null;
        }
        if (doSpaces) {
            for (String s : this.values) {
                sb.append(s + " ");
            }
        } else {
            for (String s : this.values) {
                sb.append(s);
            }
        }
        return sb.toString().trim();
    }

    public List<String> getStrings() {
        return this.values;
    }

    public int getSum() throws Exception {
        int sum = 0;
        for (String s : this.values) {
            try {
                sum += Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new Exception("The value " + this.longName + " is not an integer.");
            }
        }
        return sum;
    }

    public double getRealSum() throws Exception {
        double sum = 0.0;
        for (String s : this.values) {
            try {
                sum += Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new Exception("The value " + this.longName + " is not a value.");
            }
        }
        return sum;
    }
}

