/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.option;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.logging.LoggingUtil;
import net.praqma.logging.PraqmaticLogFormatter;
import net.praqma.util.option.Option;
import net.praqma.util.time.TimeUtils;

public class Options {
    private static Logger logger = Logger.getLogger(Options.class.getName());
    private List<Option> options = new ArrayList<Option>();
    private String syntax = "";
    private String header = "";
    private String description = "";
    private String version = "";
    private Option ohelp = null;
    private Option oversion = null;
    private Option overbose = null;
    private Option odebug = null;
    private Option otemplate = null;
    private Option ologfile = null;
    private Level used = Level.INFO;
    private boolean verbose = false;
    public static final String linesep = System.getProperty("line.separator");
    private Option otiming = null;
    private long millis;

    public Options() {
        this.initialize();
    }

    public Options(String version) {
        this.version = version;
        this.initialize();
        this.millis = System.currentTimeMillis();
    }

    private void initialize() {
        LoggingUtil.changeLoggerFormat(new PraqmaticLogFormatter().setFormat("[{1}]{5} {4} \n{8}"));
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Options.this.shutdown(((Options)Options.this).otiming.used, Options.this.millis);
            }
        });
    }

    protected void shutdown(boolean used, long millis) {
        try {
            if (used) {
                long now = System.currentTimeMillis();
                double t = Math.floor(now - millis) / 1000.0;
                System.out.println("Time taken: " + TimeUtils.getTimeString(now - millis));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setDefaultOptions() {
        this.ohelp = new Option("help", "h", false, 0, "Display help");
        this.oversion = new Option("version", null, false, 0, "Print the version");
        this.overbose = new Option("verbose", null, false, 0, "Verbose");
        this.odebug = new Option("debug", null, false, 0, "Debug");
        this.otemplate = new Option("template", null, false, 1, "Output template");
        this.ologfile = new Option("logfile", null, false, -1, "Set a file to log to");
        this.otiming = new Option("timing", null, false, 0, "Enable timing");
        this.setOption(this.ohelp);
        this.setOption(this.oversion);
        this.setOption(this.overbose);
        this.setOption(this.odebug);
        this.setOption(this.otiming);
        this.setOption(this.otemplate);
        this.setOption(this.ologfile);
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setOption(Option option) {
        this.options.add(option);
    }

    public void parse(String[] args) {
        String currentStr = null;
        Option current = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].startsWith("-", 1)) {
                    currentStr = args[i].substring(2);
                    current = null;
                    String[] val = currentStr.split("=", 2);
                    if (val.length == 2) {
                        currentStr = val[0];
                    }
                    for (Option o : this.options) {
                        if (!currentStr.equalsIgnoreCase(o.longName)) continue;
                        current = o;
                        if (val.length == 2) {
                            o.addValue(val[1]);
                        }
                        o.setUsed();
                    }
                    continue;
                }
                currentStr = args[i].substring(1);
                current = null;
                for (Option o : this.options) {
                    if (!currentStr.equals(o.shortName)) continue;
                    current = o;
                    o.setUsed();
                }
                continue;
            }
            if (current == null) continue;
            current.addValue(args[i]);
        }
        this.verboseUsed();
        this.setTemplate();
        if (this.isVerbose()) {
            LoggingUtil.changeLoggerLevel(Level.CONFIG);
            this.used = Level.CONFIG;
        } else {
            LoggingUtil.changeLoggerLevel(Level.INFO);
            this.used = Level.INFO;
        }
        if (this.odebug.isUsed()) {
            LoggingUtil.changeLoggerLevel(Level.ALL);
            if (!this.otemplate.isUsed()) {
                LoggingUtil.changeLoggerFormat(new PraqmaticLogFormatter().setFormat("{3,date,HH:mm:ss} [{1}]{5} {6}.{7}, {19}: {4} \n{8}"));
            }
            this.used = Level.ALL;
        }
    }

    private void helpUsed() {
        if (this.ohelp != null && this.ohelp.used) {
            this.display();
            System.exit(0);
        }
    }

    private void versionUsed() {
        if (this.oversion != null && this.oversion.used) {
            System.out.println(this.version);
            System.exit(0);
        }
    }

    private void verboseUsed() {
        if (this.overbose != null && this.overbose.used) {
            this.verbose = true;
        }
    }

    public void setTemplate() {
        if (this.otemplate.isUsed()) {
            LoggingUtil.changeLoggerFormat(new PraqmaticLogFormatter(this.otemplate.getString()));
        }
    }

    private void logfileUsed() {
        if (this.ologfile.isUsed()) {
            File file = new File(this.ologfile.getString());
            try {
                FileOutputStream out = new FileOutputStream(file);
                LoggingUtil.addOutput(out, new PraqmaticLogFormatter());
                LoggingUtil.changeLoggerLevel(this.used);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void checkOptions() throws Exception {
        this.helpUsed();
        this.versionUsed();
        this.logfileUsed();
        String errors = "";
        for (Option o : this.options) {
            if (o.required && !o.used) {
                errors = errors + o.longName + " is not used and is not optional." + linesep;
            }
            if (o.arguments == o.values.size() || o.arguments <= -1 || !o.used) continue;
            errors = errors + "Incorrect arguments for option " + o.longName + ". " + o.arguments + " required." + linesep;
        }
        if (errors.length() > 0) {
            throw new Exception(errors);
        }
    }

    public boolean verbose() {
        return this.verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.odebug != null && this.odebug.isUsed();
    }

    public void print() {
        System.out.println("Printing " + this.options.size() + " option" + (this.options.size() == 1 ? "" : "s"));
        for (Option o : this.options) {
            System.out.print(o.longName + ": ");
            System.out.print(o.used ? "Used " : "Unused ");
            if (o.values.size() > 0) {
                System.out.print("Values:");
                int c = 0;
                for (String s : o.values) {
                    System.out.print(" [" + ++c + "] " + s);
                }
            }
            System.out.println("");
        }
    }

    public void display() {
        if (this.header.length() > 0) {
            System.out.println(this.header + linesep);
        }
        System.out.println("Usage: " + this.syntax + linesep);
        for (Option o : this.options) {
            System.out.print("  --" + o.longName);
            if (o.shortName != null && o.shortName.length() > 0) {
                System.out.print(new String(new char[15 - o.longName.length()]).replace("\u0000", " ") + "-" + o.shortName);
            } else {
                System.out.print(new String(new char[16 - o.longName.length()]).replace("\u0000", " "));
            }
            System.out.print("\t" + (o.required ? "Required" : "Optional"));
            System.out.println("\t" + o.description);
        }
        if (this.description.length() > 0) {
            System.out.println(linesep + this.description);
        }
    }

    public String toString() {
        return "";
    }
}

