/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Report {
    private static Logger logger = Logger.getLogger(Report.class.getName());
    protected List<List<String>> rows = new ArrayList<List<String>>();
    protected File output;
    protected Writer out;

    public Report addRow(List<String> row) {
        this.rows.add(row);
        return this;
    }

    public Report setOutputFile(File outputFile) {
        this.output = outputFile;
        return this;
    }

    public Report setWriter(Writer out) {
        this.out = out;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate() throws IOException {
        PrintWriter thisOut;
        logger.fine("Generating report");
        if (this.out == null) {
            if (this.output == null) throw new IllegalStateException("No output destination given");
            thisOut = new PrintWriter(this.output);
        } else {
            thisOut = new PrintWriter(this.out);
        }
        logger.fine("Output is " + thisOut);
        this.generateHeader(thisOut);
        for (List<String> row : this.rows) {
            this.generateRow(thisOut, row);
        }
        this.generateFooter(thisOut);
        this.out.close();
    }

    public abstract void generateHeader(PrintWriter var1);

    public abstract void generateRow(PrintWriter var1, List<String> var2);

    public abstract void generateFooter(PrintWriter var1);
}

