/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.praqma.util.debug.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML {
    private Document doc;
    private Element root;
    protected Logger logger;

    public XML() {
        this(false);
    }

    public XML(boolean XIncludeAware) {
        this.logger = Logger.getLogger();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (XIncludeAware) {
            factory.setXIncludeAware(true);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public XML(String roottag) {
        this(roottag, false);
    }

    public XML(String roottag, boolean XIncludeAware) {
        this.logger = Logger.getLogger();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (XIncludeAware) {
            factory.setXIncludeAware(true);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.root = (Element)this.doc.appendChild(this.doc.createElement(roottag));
    }

    public XML(File xmlfile) throws IOException {
        this(xmlfile, false);
    }

    public XML(File xmlfile, boolean XIncludeAware) throws IOException {
        this.logger = Logger.getLogger();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (XIncludeAware) {
            factory.setXIncludeAware(true);
        }
        FileInputStream is = new FileInputStream(xmlfile);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.root = this.doc.getDocumentElement();
    }

    public XML(File xmlfile, String roottag) throws IOException {
        this(xmlfile, roottag, false);
    }

    public XML(File xmlfile, String roottag, boolean XIncludeAware) throws IOException {
        block5: {
            this.logger = Logger.getLogger();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            if (XIncludeAware) {
                factory.setXIncludeAware(true);
            }
            FileInputStream is = new FileInputStream(xmlfile);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.doc = builder.parse(is);
                this.root = this.doc.getDocumentElement();
            }
            catch (Exception e) {
                this.logger.debug("The file " + xmlfile + " does not exist");
                if (roottag == null) break block5;
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    this.doc = builder.newDocument();
                    this.logger.debug("The document was created");
                    this.root = (Element)this.doc.appendChild(this.doc.createElement(roottag));
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                    this.logger.error("Could not create document");
                }
            }
        }
    }

    public XML(InputStream is) {
        this(is, false);
    }

    public XML(InputStream is, boolean XIncludeAware) {
        this.logger = Logger.getLogger();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (XIncludeAware) {
            factory.setXIncludeAware(true);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.root = this.doc.getDocumentElement();
    }

    public Element addElement(String tag) {
        return this.addElement(this.root, tag);
    }

    public Element addElement(Element root, String tag) {
        return (Element)root.appendChild(this.doc.createElement(tag));
    }

    public Element appendElement(Element e) {
        this.root.appendChild(e);
        return e;
    }

    public Element appendElement(Element e, Element root) {
        root.appendChild(e);
        return e;
    }

    public Element createElement(String tagName) {
        return this.doc.createElement(tagName);
    }

    public Element createElement(String tagName, Element root) {
        Element e = this.doc.createElement(tagName);
        root.appendChild(e);
        return e;
    }

    public Element getRoot() {
        return this.root;
    }

    public Element getFirstElement(String tag) throws DOMException {
        return this.getFirstElement(this.root, tag);
    }

    public Element getFirstElement(Element e, String tag) throws DOMException {
        NodeList list = e.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(tag)) continue;
            return (Element)node;
        }
        throw new DOMException(1, "Could not GetElement " + tag);
    }

    public List<Element> getElements() {
        return this.getElements(this.root);
    }

    public List<Element> getElements(Element e) {
        NodeList list = e.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element e1 = (Element)node;
            result.add(e1);
        }
        return result;
    }

    public List<Element> getElements(Element e, String tag) {
        NodeList list = e.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(tag)) continue;
            Element e1 = (Element)node;
            result.add(e1);
        }
        return result;
    }

    public List<Element> getElementsWithAttribute(Element e, String attr, String name) {
        NodeList list = e.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e1;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !(e1 = (Element)node).getAttribute(attr).equals(name)) continue;
            result.add(e1);
        }
        return result;
    }

    public List<Element> getElementsWithAttribute(Element e, String tag, String attr, String name) {
        NodeList list = e.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element e1;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(tag) || !(e1 = (Element)node).getAttribute(attr).equals(name)) continue;
            result.add(e1);
        }
        return result;
    }

    public String getXML() {
        StringWriter out = new StringWriter();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource src = new DOMSource(this.doc);
            StreamResult dest = new StreamResult(out);
            transformer.transform(src, dest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public Source getXMLAsSource() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return new DOMSource(this.doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String transform(File xml, String xsl, File output) {
        StreamSource xmlSource = new StreamSource(xml);
        StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream(xsl));
        return this.transform(xmlSource, xsltSource, output);
    }

    public String transform(String xsl, File output) {
        StreamSource xsltSource = null;
        try {
            xsltSource = new StreamSource(this.getClass().getResourceAsStream(xsl));
            this.logger.log("Using " + xsl + " as XSLT");
        }
        catch (Exception e) {
            this.logger.log("Could not find the XSLT file, using SECRET XSLT");
            xsltSource = new StreamSource("C:\\projects\\PRAQMA\\VANS\\trunk\\src\\main\\resources\\junit.xsl");
        }
        return this.transform(new DOMSource(this.doc), xsltSource, output);
    }

    public String transform(Source xmlSource, StreamSource xsltSource, File output) {
        TransformerFactory transFact = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFact.newTransformer(xsltSource);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("method", "xml");
            FileOutputStream os = new FileOutputStream(output);
            transformer.transform(xmlSource, new StreamResult(os));
            return os.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void saveState(File filename) {
        String xml = this.getXML();
        try {
            FileWriter fw = new FileWriter(filename);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.append(xml);
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

