/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.xml.feed;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import net.praqma.util.xml.XML;
import net.praqma.util.xml.feed.Entry;
import net.praqma.util.xml.feed.Feed;
import net.praqma.util.xml.feed.FeedException;
import net.praqma.util.xml.feed.FeedPublisher;
import net.praqma.util.xml.feed.Person;
import org.w3c.dom.Element;

public class AtomPublisher
extends FeedPublisher {
    public String toFeed(Feed feed, int limit) throws FeedException {
        XML xml = new XML("feed");
        Element root = xml.getRoot();
        root.setAttribute("xmlns", "http://www.w3.org/2005/Atom");
        if (feed.title != null) {
            xml.addElement("title").setTextContent(feed.title);
        }
        if (feed.link != null) {
            xml.addElement("link").setTextContent(feed.link);
        }
        if (feed.updated != null) {
            xml.addElement("updated").setTextContent(AtomPublisher.dateToString(feed.updated));
        }
        if (feed.author != null) {
            xml.appendElement(AtomPublisher.getPerson(feed.author, xml));
        }
        if (feed.id != null) {
            xml.addElement("id").setTextContent(feed.id);
        }
        int count = 0;
        for (Entry entry : feed.getEntries()) {
            if (count == limit) break;
            Element e = xml.createElement("entry", root);
            if (entry.title != null) {
                xml.addElement(e, "title").setTextContent(entry.title);
            }
            if (entry.link != null) {
                xml.addElement(e, "link").setTextContent(entry.link);
            }
            if (entry.author != null) {
                xml.appendElement(AtomPublisher.getPerson(entry.author, xml), e);
            }
            if (entry.id != null) {
                xml.addElement(e, "id").setTextContent(entry.id);
            }
            if (entry.updated != null) {
                xml.addElement(e, "updated").setTextContent(AtomPublisher.dateToString(entry.updated));
            }
            if (entry.summary != null) {
                xml.addElement(e, "summary").setTextContent(entry.summary);
            }
            if (entry.content != null) {
                Element cElement = xml.addElement(e, "content");
                cElement.setAttribute("type", "html");
                cElement.setTextContent(entry.content);
            }
            ++count;
        }
        return xml.getXML();
    }

    public Feed fromFeed(XML xml) throws FeedException {
        Element root = xml.getRoot();
        String title = "";
        String id = "";
        Date updated = null;
        try {
            title = xml.getFirstElement("title").getTextContent();
            id = xml.getFirstElement("id").getTextContent();
            try {
                updated = format.parse(xml.getFirstElement("updated").getTextContent());
            }
            catch (ParseException e) {
                updated = oldformat.parse(xml.getFirstElement("updated").getTextContent());
            }
        }
        catch (Exception ex) {
            throw new FeedException("Missing required elements in feed", ex);
        }
        Feed feed = new Feed(title, id, updated);
        try {
            feed.author = AtomPublisher.getPerson(xml.getFirstElement("author"), xml);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            feed.link = xml.getFirstElement("link").getTextContent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Element> elements = xml.getElements(root, "entry");
        for (Element e : elements) {
            String etitle = "";
            String eid = "";
            Date eupdated = null;
            try {
                etitle = xml.getFirstElement(e, "title").getTextContent();
                eid = xml.getFirstElement(e, "id").getTextContent();
                eupdated = format.parse(xml.getFirstElement(e, "updated").getTextContent());
            }
            catch (ParseException ex) {
                continue;
            }
            Entry entry = new Entry(etitle, eid, eupdated);
            try {
                entry.summary = xml.getFirstElement(e, "summary").getTextContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                entry.content = xml.getFirstElement(e, "content").getTextContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                entry.link = xml.getFirstElement(e, "link").getTextContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                entry.author = AtomPublisher.getPerson(xml.getFirstElement(e, "author"), xml);
            }
            catch (Exception exception) {
                // empty catch block
            }
            feed.addEntry(entry);
        }
        return feed;
    }

    public static Element getPerson(Person author, XML xml) throws FeedException {
        Element e = xml.createElement("author");
        if (author.name == null) {
            throw new FeedException("Author requires name");
        }
        xml.createElement("name", e).setTextContent(author.name);
        if (author.uri != null) {
            xml.createElement("uri", e).setTextContent(author.uri);
        }
        if (author.email != null) {
            xml.createElement("email", e).setTextContent(author.email);
        }
        return e;
    }

    public static Person getPerson(Element e, XML xml) throws FeedException {
        String name = "";
        try {
            name = xml.getFirstElement(e, "name").getTextContent();
        }
        catch (Exception ex) {
            throw new FeedException("Missing required elements in person", ex);
        }
        Person p = new Person(name);
        return p;
    }
}

