/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.util.xml.feed;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.praqma.util.xml.XML;
import net.praqma.util.xml.feed.Entry;
import net.praqma.util.xml.feed.FeedException;
import net.praqma.util.xml.feed.FeedPublisher;
import net.praqma.util.xml.feed.Person;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed {
    public String id;
    public String title;
    public Date updated;
    public String link;
    public Person author;
    private List<Entry> entries = new ArrayList<Entry>();

    public Feed(String title, String id, Date updated) {
        this.title = title;
        this.id = id;
        this.updated = updated;
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getXML(FeedPublisher publisher) throws FeedException {
        Collections.sort(this.entries, new AscendingDateSort());
        return publisher.toFeed(this, -1);
    }

    public String getXML(FeedPublisher publisher, int limit) throws FeedException {
        Collections.sort(this.entries, new AscendingDateSort());
        return publisher.toFeed(this, limit);
    }

    public static Feed getFeed(FeedPublisher publisher, File file) throws FeedException, IOException {
        XML xml = new XML(file);
        Feed feed = publisher.fromFeed(xml);
        Collections.sort(feed.entries, new AscendingDateSort());
        return feed;
    }

    public static Feed getFeed(FeedPublisher publisher, XML xml) throws FeedException {
        Feed feed = publisher.fromFeed(xml);
        Collections.sort(feed.entries, new AscendingDateSort());
        return feed;
    }

    public String toString() {
        return this.title + "(" + this.id + "/" + this.updated + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AscendingDateSort
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            if (e1.updated == null) {
                return -1;
            }
            if (e2.updated == null) {
                return 1;
            }
            return (int)(e2.updated.getTime() / 1000L - e1.updated.getTime() / 1000L);
        }
    }
}

