/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public interface SignerVerifier {
    public byte[] sign(byte[] var1);

    default public String sign(String data) {
        return this.sign(data, StandardCharsets.UTF_8);
    }

    default public String sign(String data, Charset charset) {
        byte[] encryptedData = this.sign(data.getBytes(charset));
        return Base64.getEncoder().encodeToString(encryptedData);
    }

    public boolean verify(byte[] var1, byte[] var2);

    default public boolean verify(String data, String signature) {
        return this.verify(data, signature, StandardCharsets.UTF_8);
    }

    default public boolean verify(String data, String signature, Charset charset) {
        byte[] sign = Base64.getDecoder().decode(signature);
        return this.verify(data.getBytes(charset), sign);
    }
}

