/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.prasenjit.crypto.Encryptor;
import net.prasenjit.crypto.KeyEncryptor;

public interface TextEncryptor
extends Encryptor,
KeyEncryptor {
    default public String encrypt(String data) {
        return this.encrypt(data, StandardCharsets.UTF_8);
    }

    default public String decrypt(String data) {
        return this.decrypt(data, StandardCharsets.UTF_8);
    }

    default public String encrypt(String data, Charset charset) {
        byte[] encryptedData = this.encrypt(data.getBytes(charset));
        return Base64.getEncoder().encodeToString(encryptedData);
    }

    default public String decrypt(String data, Charset charset) {
        byte[] encryptedData = Base64.getDecoder().decode(data);
        byte[] decryptedData = this.decrypt(encryptedData);
        return new String(decryptedData, charset);
    }
}

