/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.endtoend;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import net.prasenjit.crypto.TextEncryptor;
import net.prasenjit.crypto.exception.CryptoException;
import net.prasenjit.crypto.impl.RsaEncryptor;
import net.prasenjit.crypto.store.CryptoKeyFactory;

public class RsaEncryptorBuilder {
    public static TextEncryptor client(PublicKey publicKey) {
        return new RsaEncryptor(publicKey);
    }

    public static TextEncryptor client(BigInteger modulus, BigInteger publicExponent) {
        try {
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, publicExponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(spec);
            return RsaEncryptorBuilder.client(publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException("Failed to re-construct RSA public key", e);
        }
    }

    public static TextEncryptor client(CryptoKeyFactory keyFactory, String alias) {
        return RsaEncryptorBuilder.client(keyFactory.getPublicKey(alias));
    }

    public static TextEncryptor server(PrivateKey privateKey) {
        return new RsaEncryptor(privateKey);
    }

    public static TextEncryptor server(CryptoKeyFactory keyFactory, String alias, char[] password) {
        return new RsaEncryptor(keyFactory.getPrivateKey(alias, password));
    }
}

