/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.prasenjit.crypto.TextEncryptor;
import net.prasenjit.crypto.exception.CryptoException;

public class AbstractSymmetricEncryptor
implements TextEncryptor {
    private final String algorithm;
    private final SecretKey secretKey;
    private final SecureRandom secureRandom = new SecureRandom();

    public AbstractSymmetricEncryptor(SecretKey key, String algorithm) {
        this.secretKey = key;
        this.algorithm = algorithm;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            int blockSize = cipher.getBlockSize();
            byte[] ivBytes = new byte[blockSize];
            this.secureRandom.nextBytes(ivBytes);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            cipher.init(1, (Key)this.secretKey, iv);
            byte[] encryptedBytes = cipher.doFinal(data);
            byte[] finalData = new byte[encryptedBytes.length + ivBytes.length];
            System.arraycopy(encryptedBytes, 0, finalData, 0, encryptedBytes.length);
            System.arraycopy(ivBytes, 0, finalData, encryptedBytes.length, ivBytes.length);
            return finalData;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            int blockSize = cipher.getBlockSize();
            byte[] ivBytes = new byte[blockSize];
            System.arraycopy(data, data.length - ivBytes.length, ivBytes, 0, ivBytes.length);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            cipher.init(2, (Key)this.secretKey, iv);
            return cipher.doFinal(data, 0, data.length - ivBytes.length);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    @Override
    public String wrapKey(Key key) {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            int blockSize = cipher.getBlockSize();
            byte[] ivBytes = new byte[blockSize];
            this.secureRandom.nextBytes(ivBytes);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            cipher.init(3, (Key)this.secretKey, iv);
            byte[] encryptedBytes = cipher.wrap(key);
            byte[] finalData = new byte[encryptedBytes.length + ivBytes.length];
            System.arraycopy(encryptedBytes, 0, finalData, 0, encryptedBytes.length);
            System.arraycopy(ivBytes, 0, finalData, encryptedBytes.length, ivBytes.length);
            return Base64.getEncoder().encodeToString(finalData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Wrap failed", e);
        }
    }

    @Override
    public Key unwrapKey(String encryptedKey, String algorithm, int type) {
        try {
            byte[] data = Base64.getDecoder().decode(encryptedKey);
            Cipher cipher = Cipher.getInstance(this.algorithm);
            int blockSize = cipher.getBlockSize();
            byte[] ivBytes = new byte[blockSize];
            System.arraycopy(data, data.length - ivBytes.length, ivBytes, 0, ivBytes.length);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            cipher.init(4, (Key)this.secretKey, iv);
            byte[] encryptedBytes = new byte[data.length - blockSize];
            System.arraycopy(data, 0, encryptedBytes, 0, encryptedBytes.length);
            return cipher.unwrap(encryptedBytes, algorithm, type);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoException("Unwrap failed", e);
        }
    }
}

