/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.impl;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.prasenjit.crypto.E2eEncryptor;
import net.prasenjit.crypto.exception.CryptoException;
import net.prasenjit.crypto.impl.AesEncryptor;
import net.prasenjit.crypto.impl.RsaEncryptor;

public class AesOverRsaEncryptor
implements E2eEncryptor {
    private final SecretKey secretKey;
    private final AesEncryptor aesEncryptor;
    private final RsaEncryptor rsaEncryptor;
    private boolean serverMode = true;

    public AesOverRsaEncryptor(RsaEncryptor rsaEncryptor) {
        this.rsaEncryptor = rsaEncryptor;
        this.serverMode = false;
        try {
            this.secretKey = KeyGenerator.getInstance("AES").generateKey();
            this.aesEncryptor = new AesEncryptor(this.secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("Failed to generate AES key");
        }
    }

    public AesOverRsaEncryptor(RsaEncryptor rsaEncryptor, String encodedAesKey) {
        this.rsaEncryptor = rsaEncryptor;
        this.secretKey = rsaEncryptor.unwrapKey(encodedAesKey, "AES", 3);
        this.aesEncryptor = new AesEncryptor(this.secretKey);
    }

    @Override
    public String getEncryptedKey() {
        if (this.serverMode) {
            throw new CryptoException("Unsupported operation for E2E server");
        }
        return this.rsaEncryptor.wrapKey(this.secretKey);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return this.aesEncryptor.encrypt(data);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        return this.aesEncryptor.decrypt(data);
    }

    @Override
    public String wrapKey(Key key) {
        return this.rsaEncryptor.wrapKey(key);
    }

    @Override
    public Key unwrapKey(String encryptedKey, String algorithm, int type) {
        return this.rsaEncryptor.unwrapKey(encryptedKey, algorithm, type);
    }
}

