/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.prasenjit.crypto.TextEncryptor;
import net.prasenjit.crypto.exception.CryptoException;

public class PBEEncryptor
implements TextEncryptor {
    private static final String ALGORITHM = "PBEWithMD5AndDES";
    private final SecureRandom secureRandom = new SecureRandom();
    private final SecretKey secretKey;

    public PBEEncryptor(char[] password) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            this.secretKey = secretKeyFactory.generateSecret(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException("Key generation failed", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] data) {
        byte[] salt = new byte[8];
        this.secureRandom.nextBytes(salt);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 19);
            cipher.init(1, (Key)this.secretKey, paramSpec);
            byte[] encripted = cipher.doFinal(data);
            byte[] encFinal = new byte[encripted.length + salt.length];
            System.arraycopy(encripted, 0, encFinal, 0, encripted.length);
            System.arraycopy(salt, 0, encFinal, encripted.length, salt.length);
            return encFinal;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        byte[] salt = new byte[8];
        System.arraycopy(data, data.length - salt.length, salt, 0, salt.length);
        byte[] encripted = new byte[data.length - salt.length];
        System.arraycopy(data, 0, encripted, 0, data.length - salt.length);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 19);
            cipher.init(2, (Key)this.secretKey, paramSpec);
            return cipher.doFinal(encripted);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Decryption failed", e);
        }
    }

    @Override
    public String wrapKey(Key key) {
        try {
            byte[] salt = new byte[8];
            this.secureRandom.nextBytes(salt);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 19);
            cipher.init(3, (Key)this.secretKey, paramSpec);
            byte[] encryptedBytes = cipher.wrap(key);
            byte[] finalData = new byte[encryptedBytes.length + salt.length];
            System.arraycopy(encryptedBytes, 0, finalData, 0, encryptedBytes.length);
            System.arraycopy(salt, 0, finalData, encryptedBytes.length, salt.length);
            return Base64.getEncoder().encodeToString(finalData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Wrap failed", e);
        }
    }

    @Override
    public Key unwrapKey(String encryptedKey, String algorithm, int type) {
        try {
            byte[] data = Base64.getDecoder().decode(encryptedKey);
            byte[] salt = new byte[8];
            byte[] encrypted = new byte[data.length - salt.length];
            System.arraycopy(data, data.length - salt.length, salt, 0, salt.length);
            System.arraycopy(data, 0, encrypted, 0, data.length - salt.length);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 19);
            cipher.init(4, (Key)this.secretKey, paramSpec);
            return cipher.unwrap(encrypted, algorithm, type);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoException("Unwrap failed", e);
        }
    }
}

