/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.impl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import net.prasenjit.crypto.TextEncryptor;
import net.prasenjit.crypto.exception.CryptoException;

public class RsaEncryptor
implements TextEncryptor {
    private static final String ALGORITHM = "RSA";
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public RsaEncryptor(PrivateKey privateKey) {
        this.privateKey = privateKey;
        if (!(privateKey instanceof RSAKey)) {
            throw new CryptoException("Only RSA keys are supported with RsaEncryptor");
        }
    }

    public RsaEncryptor(PublicKey publicKey) {
        this.publicKey = publicKey;
        if (!(publicKey instanceof RSAKey)) {
            throw new CryptoException("Only RSA keys are supported with RsaEncryptor");
        }
    }

    public RsaEncryptor(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        if (!(publicKey instanceof RSAKey)) {
            throw new CryptoException("Only RSA keys are supported with RsaEncryptor");
        }
        this.privateKey = privateKey;
        if (!(privateKey instanceof RSAKey)) {
            throw new CryptoException("Only RSA keys are supported with RsaEncryptor");
        }
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (this.publicKey == null) {
            throw new CryptoException("PublicKey not found for encryption");
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, this.publicKey);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Encryption failed", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) {
        if (this.privateKey == null) {
            throw new CryptoException("PrivateKey not found for decryption");
        }
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, this.privateKey);
            return cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Decryption failed", e);
        }
    }

    @Override
    public String wrapKey(Key keyToWrap) {
        if (this.publicKey == null) {
            throw new CryptoException("PublicKey not found for encryption");
        }
        try {
            Cipher wrapper = Cipher.getInstance(ALGORITHM);
            wrapper.init(3, this.publicKey);
            byte[] wrappedKey = wrapper.wrap(keyToWrap);
            return Base64.getEncoder().encodeToString(wrappedKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Failed to wrap key", e);
        }
    }

    @Override
    public SecretKey unwrapKey(String wrappedKey, String algorithm, int type) {
        if (this.privateKey == null) {
            throw new CryptoException("PrivateKey not found for decryption");
        }
        try {
            Cipher wrapper = Cipher.getInstance(ALGORITHM);
            wrapper.init(4, this.privateKey);
            byte[] wrappedByte = Base64.getDecoder().decode(wrappedKey);
            return (SecretKey)wrapper.unwrap(wrappedByte, algorithm, type);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoException("Failed to wrap key", e);
        }
    }
}

