/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import net.prasenjit.crypto.SignerVerifier;
import net.prasenjit.crypto.exception.CryptoException;

public class RsaSignerVerifier
implements SignerVerifier {
    public static final String ALGORITHM = "SHA1WithRSA";
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public RsaSignerVerifier(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public RsaSignerVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
        this.privateKey = null;
    }

    public RsaSignerVerifier(PrivateKey privateKey) {
        this.publicKey = null;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] sign(byte[] data) {
        if (this.privateKey != null) {
            try {
                Signature signature = Signature.getInstance(ALGORITHM);
                signature.initSign(this.privateKey);
                signature.update(data);
                return signature.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new CryptoException("Signature failed", e);
            }
        }
        throw new CryptoException("Private key not found, sign not supported");
    }

    @Override
    public boolean verify(byte[] data, byte[] sign) {
        if (this.publicKey != null) {
            try {
                Signature signature = Signature.getInstance(ALGORITHM);
                signature.initVerify(this.publicKey);
                signature.update(data);
                return signature.verify(sign);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new CryptoException("Verification failed", e);
            }
        }
        throw new CryptoException("Public key not found, verify not supported");
    }
}

