/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import net.prasenjit.crypto.PasswordEncryptor;
import net.prasenjit.crypto.exception.CryptoException;

public class SshaPasswordEncryptor
implements PasswordEncryptor {
    private final SecureRandom secureRandom = new SecureRandom();

    @Override
    public String encrypt(String plainPassword) {
        byte[] salt = new byte[8];
        this.secureRandom.nextBytes(salt);
        byte[] data = plainPassword.getBytes(StandardCharsets.UTF_8);
        byte[] digest = this.digest(data, salt);
        byte[] output = new byte[digest.length + salt.length];
        System.arraycopy(digest, 0, output, 0, digest.length);
        System.arraycopy(salt, 0, output, digest.length, salt.length);
        return Base64.getEncoder().encodeToString(output);
    }

    @Override
    public boolean testMatch(String plainPassword, String encryptedPassword) {
        byte[] data = Base64.getDecoder().decode(encryptedPassword);
        byte[] salt = new byte[8];
        byte[] digested = new byte[data.length - salt.length];
        System.arraycopy(data, data.length - salt.length, salt, 0, salt.length);
        System.arraycopy(data, 0, digested, 0, data.length - salt.length);
        byte[] newData = this.digest(plainPassword.getBytes(StandardCharsets.UTF_8), salt);
        return Arrays.equals(digested, newData);
    }

    private byte[] digest(byte[] data, byte[] salt) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data);
            return messageDigest.digest(salt);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("Failed to digest password");
        }
    }
}

