/*
 * Decompiled with CFR 0.152.
 */
package net.prasenjit.crypto.store;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import net.prasenjit.crypto.exception.CryptoException;

public class CryptoKeyFactory {
    private static final Logger log = Logger.getLogger(CryptoKeyFactory.class.getName());
    private String type = "JKS";
    private URL location;
    private String locationStr;
    private String password = "changeit";
    private String providerName;
    private Provider provider;
    private String providerClassName;
    private transient KeyStore keyStore;

    private synchronized void initilize() {
        try {
            if (this.provider != null) {
                this.keyStore = KeyStore.getInstance(this.type, this.provider);
            } else if (this.providerClassName != null) {
                Provider loadedProvider = (Provider)Class.forName(this.providerClassName).newInstance();
                Security.addProvider(loadedProvider);
                this.provider = loadedProvider;
                this.providerName = loadedProvider.getName();
                this.keyStore = KeyStore.getInstance(this.type, this.provider);
            } else {
                this.keyStore = this.providerName != null ? KeyStore.getInstance(this.type, this.providerName) : KeyStore.getInstance(this.type);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | KeyStoreException | NoSuchProviderException e) {
            throw new CryptoException("Failed to instanciate key store", e);
        }
        InputStream inputStream = null;
        try {
            if (this.locationStr != null) {
                this.location = URI.create(this.locationStr).toURL();
            }
            inputStream = this.location != null ? this.location.openStream() : null;
            char[] passwordChar = this.password != null ? this.password.toCharArray() : null;
            this.keyStore.load(inputStream, passwordChar);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new CryptoException("Failed to load key store", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close stream", e);
                }
            }
        }
    }

    public SecretKey getSecretKey(String alias, char[] password) {
        this.initilize();
        try {
            Key key = this.keyStore.getKey(alias, password);
            if (key != null && key instanceof SecretKey) {
                return (SecretKey)key;
            }
            return null;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoException("Failed to extract secret key", e);
        }
    }

    public PrivateKey getPrivateKey(String alias, char[] password) {
        this.initilize();
        try {
            Key key = this.keyStore.getKey(alias, password);
            if (key != null && key instanceof PrivateKey) {
                return (PrivateKey)key;
            }
            return null;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoException("Failed to extract private key", e);
        }
    }

    public PublicKey getPublicKey(String alias) {
        this.initilize();
        try {
            Certificate certificate = this.keyStore.getCertificate(alias);
            if (certificate != null) {
                return certificate.getPublicKey();
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new CryptoException("Failed to extract public key", e);
        }
    }

    public Certificate getCertificate(String alias) {
        this.initilize();
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoException("Failed to extract certificate", e);
        }
    }

    public KeyPair getKeyPair(String alias, char[] password) {
        this.initilize();
        try {
            Certificate certificate;
            Key key = this.keyStore.getKey(alias, password);
            if (key != null && key instanceof PrivateKey && (certificate = this.keyStore.getCertificate(alias)) != null) {
                return new KeyPair(certificate.getPublicKey(), (PrivateKey)key);
            }
            throw new CryptoException("No key pair available for alias " + alias);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoException("Failed to extract private key", e);
        }
    }

    @ConstructorProperties(value={"type", "location", "locationStr", "password", "providerName", "provider", "providerClassName", "keyStore"})
    CryptoKeyFactory(String type, URL location, String locationStr, String password, String providerName, Provider provider, String providerClassName, KeyStore keyStore) {
        this.type = type;
        this.location = location;
        this.locationStr = locationStr;
        this.password = password;
        this.providerName = providerName;
        this.provider = provider;
        this.providerClassName = providerClassName;
        this.keyStore = keyStore;
    }

    public static CryptoKeyFactoryBuilder builder() {
        return new CryptoKeyFactoryBuilder();
    }

    public static class CryptoKeyFactoryBuilder {
        private String type;
        private URL location;
        private String locationStr;
        private String password;
        private String providerName;
        private Provider provider;
        private String providerClassName;
        private KeyStore keyStore;

        CryptoKeyFactoryBuilder() {
        }

        public CryptoKeyFactoryBuilder type(String type) {
            this.type = type;
            return this;
        }

        public CryptoKeyFactoryBuilder location(URL location) {
            this.location = location;
            return this;
        }

        public CryptoKeyFactoryBuilder locationStr(String locationStr) {
            this.locationStr = locationStr;
            return this;
        }

        public CryptoKeyFactoryBuilder password(String password) {
            this.password = password;
            return this;
        }

        public CryptoKeyFactoryBuilder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public CryptoKeyFactoryBuilder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        public CryptoKeyFactoryBuilder providerClassName(String providerClassName) {
            this.providerClassName = providerClassName;
            return this;
        }

        public CryptoKeyFactoryBuilder keyStore(KeyStore keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public CryptoKeyFactory build() {
            return new CryptoKeyFactory(this.type, this.location, this.locationStr, this.password, this.providerName, this.provider, this.providerClassName, this.keyStore);
        }

        public String toString() {
            return "CryptoKeyFactory.CryptoKeyFactoryBuilder(type=" + this.type + ", location=" + this.location + ", locationStr=" + this.locationStr + ", password=" + this.password + ", providerName=" + this.providerName + ", provider=" + this.provider + ", providerClassName=" + this.providerClassName + ", keyStore=" + this.keyStore + ")";
        }
    }
}

