/*
 * @(#) GeneratorContext.kt
 *
 * json-kotlin-schema-codegen  JSON Schema Code Generation
 * Copyright (c) 2022 Peter Wall
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package net.pwall.json.schema.codegen

import java.time.LocalDate
import java.time.LocalTime
import java.time.OffsetDateTime
import java.util.UUID

/**
 * Context object to provide constants for code generation template expansion.
 *
 * @author  Peter Wall
 */
object GeneratorContext {

    @Suppress("unused")
    val dateTime: OffsetDateTime = OffsetDateTime.now()

    @Suppress("unused")
    val date: LocalDate
        get() = dateTime.toLocalDate()

    @Suppress("unused")
    val time: LocalTime
        get() = dateTime.toLocalTime()

    @Suppress("unused")
    val generator: String = "net.pwall.json.schema.codegen.CodeGenerator"

    @Suppress("unused")
    val uuid: UUID = UUID.randomUUID()

    @Suppress("unused")
    val openBrace = '{'

    @Suppress("unused")
    val closeBrace = '}'

    @Suppress("unused")
    val openAngleBracket = '<'

    @Suppress("unused")
    val closeAngleBracket = '>'

}
