/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.codegen;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.schema.codegen.ValidationValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lnet/pwall/json/schema/codegen/NumberValue;", "Lnet/pwall/json/schema/codegen/ValidationValue;", "rawNumber", "", "(Ljava/lang/Number;)V", "asLong", "", "getAsLong", "()J", "isDecimal", "", "()Z", "isInt", "isLong", "isOne", "isZero", "getRawNumber", "()Ljava/lang/Number;", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "json-kotlin-schema-codegen"})
public final class NumberValue
implements ValidationValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number rawNumber;

    public NumberValue(@NotNull Number rawNumber) {
        Intrinsics.checkNotNullParameter((Object)rawNumber, (String)"rawNumber");
        this.rawNumber = rawNumber;
        if (!(this.rawNumber instanceof Integer || this.rawNumber instanceof Long || this.rawNumber instanceof BigDecimal)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Number getRawNumber() {
        return this.rawNumber;
    }

    public final boolean isInt() {
        return this.rawNumber instanceof Integer;
    }

    public final boolean isLong() {
        return this.rawNumber instanceof Long;
    }

    public final boolean isDecimal() {
        return this.rawNumber instanceof BigDecimal;
    }

    public final boolean isZero() {
        boolean bl;
        Number number = this.rawNumber;
        if (number instanceof Integer) {
            bl = Intrinsics.areEqual((Object)this.rawNumber, (Object)0);
        } else if (number instanceof Long) {
            bl = Intrinsics.areEqual((Object)this.rawNumber, (Object)0L);
        } else if (number instanceof BigDecimal) {
            bl = BigDecimal.ZERO.compareTo((BigDecimal)this.rawNumber) == 0;
        } else {
            throw new IllegalStateException("Impossible type in NumberValue");
        }
        return bl;
    }

    public final boolean isOne() {
        boolean bl;
        Number number = this.rawNumber;
        if (number instanceof Integer) {
            bl = Intrinsics.areEqual((Object)this.rawNumber, (Object)1);
        } else if (number instanceof Long) {
            bl = Intrinsics.areEqual((Object)this.rawNumber, (Object)1L);
        } else if (number instanceof BigDecimal) {
            bl = BigDecimal.ONE.compareTo((BigDecimal)this.rawNumber) == 0;
        } else {
            throw new IllegalStateException("Impossible type in NumberValue");
        }
        return bl;
    }

    public final long getAsLong() {
        Number number = this.rawNumber;
        return number instanceof BigDecimal ? ((BigDecimal)this.rawNumber).setScale(0, RoundingMode.DOWN).longValue() : (number instanceof Long ? this.rawNumber.longValue() : this.rawNumber.longValue());
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof NumberValue && Intrinsics.areEqual((Object)this.rawNumber, (Object)((NumberValue)other).rawNumber);
    }

    public int hashCode() {
        return this.rawNumber.hashCode();
    }

    @NotNull
    public String toString() {
        return this.rawNumber.toString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0017\u0010\u0007\u001a\u00020\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0017\u0010\b\u001a\u00020\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\u00020\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0017\u0010\n\u001a\u00020\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/codegen/NumberValue$Companion;", "", "()V", "isDecimal", "", "Lnet/pwall/json/schema/codegen/NumberValue;", "(Lnet/pwall/json/schema/codegen/NumberValue;)Z", "isInt", "isLong", "isOne", "isZero", "json-kotlin-schema-codegen"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInt(@Nullable NumberValue $this$isInt) {
            boolean bl;
            NumberValue numberValue = $this$isInt;
            return numberValue == null ? false : (bl = numberValue.isInt());
        }

        public final boolean isLong(@Nullable NumberValue $this$isLong) {
            boolean bl;
            NumberValue numberValue = $this$isLong;
            return numberValue == null ? false : (bl = numberValue.isLong());
        }

        public final boolean isDecimal(@Nullable NumberValue $this$isDecimal) {
            boolean bl;
            NumberValue numberValue = $this$isDecimal;
            return numberValue == null ? false : (bl = numberValue.isDecimal());
        }

        public final boolean isZero(@Nullable NumberValue $this$isZero) {
            boolean bl;
            NumberValue numberValue = $this$isZero;
            return numberValue == null ? false : (bl = numberValue.isZero());
        }

        public final boolean isOne(@Nullable NumberValue $this$isOne) {
            boolean bl;
            NumberValue numberValue = $this$isOne;
            return numberValue == null ? false : (bl = numberValue.isOne());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

