/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.pointer;

import java.util.function.Supplier;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointerException;
import net.pwall.pipeline.AbstractIntPipeline;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.StringAcceptor;
import net.pwall.pipeline.codec.CodePoint_UTF8;
import net.pwall.pipeline.uri.SchemaURIEncoder;
import net.pwall.util.CharMapper;
import net.pwall.util.CharUnmapper;
import net.pwall.util.Strings;
import net.pwall.util.URI;

public class JSONPointer {
    protected static final String[] emptyArray = new String[0];
    public static final JSONPointer root = new JSONPointer(emptyArray);
    private final String[] tokens;
    public static final CharMapper mapper = codePoint -> {
        if (codePoint == 126) {
            return "~0";
        }
        if (codePoint == 47) {
            return "~1";
        }
        return null;
    };
    public static final CharUnmapper unmapper = new CharUnmapper(){

        public boolean isEscape(CharSequence s, int offset) {
            return s.charAt(offset) == '~';
        }

        public int unmap(StringBuilder sb, CharSequence s, int offset) {
            int nextIndex = offset + 1;
            if (nextIndex < s.length()) {
                char ch = s.charAt(nextIndex);
                if (ch == '0') {
                    sb.append('~');
                    return 2;
                }
                if (ch == '1') {
                    sb.append('/');
                    return 2;
                }
            }
            sb.append('~');
            return 1;
        }
    };

    protected JSONPointer(String[] tokens) {
        this.tokens = tokens;
    }

    public JSONPointer(String string) {
        this(JSONPointer.parse(JSONPointer.checkNotNull(string)));
    }

    public JSONValue eval(JSONValue base) {
        return JSONPointer.find(this.tokens, base);
    }

    public JSONValue find(JSONValue base) {
        return JSONPointer.find(this.tokens, base);
    }

    public boolean exists(JSONValue base) {
        return JSONPointer.exists(this.tokens, base);
    }

    public JSONPointer parent() {
        if (this.tokens.length == 0) {
            throw new JSONPointerException("Can't get parent of root JSON Pointer");
        }
        int n = this.tokens.length - 1;
        String[] newTokens = new String[n];
        System.arraycopy(this.tokens, 0, newTokens, 0, n);
        return new JSONPointer(newTokens);
    }

    public JSONPointer child(String string) {
        JSONPointer.checkNotNull(string);
        String[] newTokens = new String[this.tokens.length + 1];
        System.arraycopy(this.tokens, 0, newTokens, 0, this.tokens.length);
        newTokens[this.tokens.length] = string;
        return new JSONPointer(newTokens);
    }

    public JSONPointer child(int index) {
        if (index < 0) {
            throw new JSONPointerException("JSON Pointer index must not be negative");
        }
        return this.child(Integer.toString(index));
    }

    public JSONPointer getPointer() {
        return this;
    }

    public String getCurrent() {
        int n = this.tokens.length;
        return n == 0 ? null : this.tokens[n - 1];
    }

    public String toURIFragment() {
        StringBuilder sb = new StringBuilder();
        sb.append('#');
        EscapePipeline pipeline = new EscapePipeline(new CodePoint_UTF8((IntAcceptor)new SchemaURIEncoder((IntAcceptor)new StringAcceptor(sb))));
        try {
            for (String token : this.tokens) {
                sb.append('/');
                pipeline.accept(token);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JSONPointer)) {
            return false;
        }
        int n = this.tokens.length;
        String[] otherTokens = ((JSONPointer)obj).tokens;
        if (n != otherTokens.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.tokens[i].equals(otherTokens[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (String token : this.tokens) {
            hash ^= token.hashCode();
        }
        return hash;
    }

    public String toString() {
        return JSONPointer.toString(this.tokens, this.tokens.length);
    }

    public static JSONValue find(String string, JSONValue base) {
        return JSONPointer.find(JSONPointer.parse(JSONPointer.checkNotNull(string)), base);
    }

    private static JSONValue find(String[] tokens, JSONValue base) {
        JSONValue result = base;
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            String token = tokens[i];
            if (result instanceof JSONMapping) {
                JSONMapping resultMapping = (JSONMapping)result;
                if (!resultMapping.containsKey((Object)token)) {
                    JSONPointer.error(tokens, i + 1);
                }
                result = (JSONValue)resultMapping.get((Object)token);
                continue;
            }
            if (result instanceof JSONSequence) {
                JSONSequence resultSequence = (JSONSequence)result;
                int ii = i + 1;
                if (token.equals("-")) {
                    throw new JSONPointerException("Can't dereference end-of-array JSON Pointer " + JSONPointer.toString(tokens, ii));
                }
                int index = JSONPointer.checkIndex(token, () -> "Illegal array index in JSON Pointer " + JSONPointer.toString(tokens, ii));
                if (index < 0 || index >= resultSequence.size()) {
                    throw new JSONPointerException("Array index out of range in JSON Pointer " + JSONPointer.toString(tokens, ii));
                }
                result = (JSONValue)resultSequence.get(index);
                continue;
            }
            JSONPointer.error(tokens, i + 1);
        }
        return result;
    }

    public static boolean exists(String string, JSONValue base) {
        return JSONPointer.exists(JSONPointer.parse(JSONPointer.checkNotNull(string)), base);
    }

    private static boolean exists(String[] tokens, JSONValue base) {
        JSONValue current = base;
        if (current == null) {
            return false;
        }
        for (String token : tokens) {
            if (current instanceof JSONMapping) {
                JSONMapping currentMapping = (JSONMapping)current;
                if (!currentMapping.containsKey((Object)token)) {
                    return false;
                }
                current = (JSONValue)currentMapping.get((Object)token);
                continue;
            }
            if (current instanceof JSONSequence) {
                JSONSequence currentSequence = (JSONSequence)current;
                if (!JSONPointer.checkNumber(token)) {
                    return false;
                }
                int index = Integer.parseInt(token);
                if (index < 0 || index >= currentSequence.size()) {
                    return false;
                }
                current = (JSONValue)currentSequence.get(index);
                continue;
            }
            return false;
        }
        return true;
    }

    private static String toString(String[] tokens, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append('/').append(JSONPointer.escapeToken(tokens[i]));
        }
        return sb.toString();
    }

    private static void error(String[] tokens, int tokenIndex) {
        throw new JSONPointerException("Can't resolve JSON Pointer " + JSONPointer.toString(tokens, tokenIndex));
    }

    private static boolean checkNumber(String token) {
        int n = token.length();
        if (n < 1 || n > 8) {
            return false;
        }
        char ch = token.charAt(0);
        if (ch == '0') {
            return n == 1;
        }
        int i = 1;
        while (true) {
            if (ch < '0' || ch > '9') {
                return false;
            }
            if (i >= n) break;
            ch = token.charAt(i++);
        }
        return true;
    }

    private static int checkIndex(String token, Supplier<String> lazyMessage) {
        if (!JSONPointer.checkNumber(token)) {
            throw new JSONPointerException(lazyMessage.get());
        }
        return Integer.parseInt(token);
    }

    protected static <T> T checkNotNull(T value) {
        if (value == null) {
            throw new NullPointerException("pointer value must not be null");
        }
        return value;
    }

    protected static String[] parse(String string) {
        if (JSONPointer.checkNotNull(string).length() == 0) {
            return emptyArray;
        }
        if (!string.startsWith("/")) {
            throw new JSONPointerException("Illegal JSON Pointer " + string);
        }
        String[] tokens = Strings.split((String)string, (int)1, (int)string.length(), (char)'/', (boolean)false, null);
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            tokens[i] = JSONPointer.unescapeToken(tokens[i]);
        }
        return tokens;
    }

    public JSONPointer locateChild(JSONValue value, JSONValue target) {
        block4: {
            block3: {
                if (value == target) {
                    return this;
                }
                if (!(value instanceof JSONMapping)) break block3;
                JSONMapping mapping = (JSONMapping)value;
                for (String key : mapping.keySet()) {
                    JSONPointer nested = this.child(key).locateChild((JSONValue)mapping.get((Object)key), target);
                    if (nested == null) continue;
                    return nested;
                }
                break block4;
            }
            if (!(value instanceof JSONSequence)) break block4;
            JSONSequence sequence = (JSONSequence)value;
            int n = sequence.size();
            for (int i = 0; i < n; ++i) {
                JSONPointer nested = this.child(i).locateChild((JSONValue)sequence.get(i), target);
                if (nested == null) continue;
                return nested;
            }
        }
        return null;
    }

    public static String encodeURI(String str) {
        String result = URI.escape((String)str);
        if (result.indexOf(43) < 0) {
            return result;
        }
        return Strings.join((Object[])Strings.split((String)result, (char)'+', (boolean)false, null), (String)"%20");
    }

    public static JSONPointer fromURIFragment(String fragment) {
        if (!fragment.startsWith("#")) {
            throw new JSONPointerException("Illegal URI fragment " + fragment);
        }
        return new JSONPointer(URI.unescape((String)fragment.substring(1)));
    }

    public static String escapeToken(String token) {
        return Strings.escape((String)token, (CharMapper)mapper);
    }

    public static String unescapeToken(String str) {
        return Strings.unescape((String)str, (CharUnmapper)unmapper);
    }

    public static class EscapePipeline<R>
    extends AbstractIntPipeline<R> {
        public EscapePipeline(IntAcceptor<R> next) {
            super(next);
        }

        public void acceptInt(int value) {
            if (value == 126) {
                this.emit(126);
                this.emit(48);
            } else if (value == 47) {
                this.emit(126);
                this.emit(49);
            } else {
                this.emit(value);
            }
        }
    }
}

