/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.pointer;

import java.util.Objects;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.pointer.JSONPointerException;

public class JSONReference
extends JSONPointer {
    private final JSONValue base;
    private final boolean valid;
    private final JSONValue value;

    private JSONReference(JSONValue base, String[] tokens, boolean valid, JSONValue value) {
        super(tokens);
        this.base = base;
        this.valid = valid;
        this.value = value;
    }

    private JSONReference(JSONValue base, String[] tokens) {
        super(tokens);
        this.base = base;
        if (this.exists(base)) {
            this.valid = true;
            this.value = this.eval(base);
        } else {
            this.valid = false;
            this.value = null;
        }
    }

    public JSONReference(JSONValue base, JSONPointer pointer) {
        this(base, JSONReference.checkNotNull(pointer).getTokens());
    }

    public JSONReference(JSONValue base, String string) {
        this(base, JSONReference.parse(JSONReference.checkNotNull(string)));
    }

    public JSONReference(JSONValue base) {
        this(base, emptyArray, base != null, base);
    }

    @Override
    public JSONPointer getPointer() {
        return new JSONPointer(this.getTokens());
    }

    public JSONValue getBase() {
        return this.base;
    }

    public boolean isValid() {
        return this.valid;
    }

    public JSONValue getValue() {
        return this.value;
    }

    public boolean hasChild(String name) {
        JSONReference.checkNotNull(name);
        return this.valid && this.value instanceof JSONMapping && ((JSONMapping)this.value).containsKey((Object)name);
    }

    public boolean hasChild(int index) {
        return this.valid && (this.value instanceof JSONSequence && index >= 0 && index < ((JSONSequence)this.value).size() || this.value instanceof JSONMapping && ((JSONMapping)this.value).containsKey((Object)Integer.toString(index)));
    }

    @Override
    public JSONReference parent() {
        String[] tokens = this.getTokens();
        int n = tokens.length;
        if (n == 0) {
            throw new JSONPointerException("Can't get parent of root JSON Pointer");
        }
        String[] newTokens = new String[--n];
        System.arraycopy(tokens, 0, newTokens, 0, n);
        return new JSONReference(this.base, newTokens);
    }

    @Override
    public JSONReference child(String name) {
        JSONMapping mapping;
        JSONReference.checkNotNull(name);
        String[] tokens = this.getTokens();
        int n = tokens.length;
        String[] newTokens = new String[n + 1];
        System.arraycopy(tokens, 0, newTokens, 0, n);
        newTokens[n] = name;
        if (this.valid && this.value instanceof JSONMapping && (mapping = (JSONMapping)this.value).containsKey((Object)name)) {
            return new JSONReference(this.base, newTokens, true, (JSONValue)mapping.get((Object)name));
        }
        return new JSONReference(this.base, newTokens, false, null);
    }

    @Override
    public JSONReference child(int index) {
        if (index < 0) {
            throw new JSONPointerException("JSON Pointer index must not be negative");
        }
        String[] tokens = this.getTokens();
        int n = tokens.length;
        String[] newTokens = new String[n + 1];
        System.arraycopy(tokens, 0, newTokens, 0, n);
        newTokens[n] = Integer.toString(index);
        if (this.valid) {
            String name;
            JSONMapping mapping;
            if (this.value instanceof JSONSequence) {
                JSONSequence sequence = (JSONSequence)this.value;
                if (index < sequence.size()) {
                    return new JSONReference(this.base, newTokens, true, (JSONValue)sequence.get(index));
                }
            } else if (this.value instanceof JSONMapping && (mapping = (JSONMapping)this.value).containsKey((Object)(name = Integer.toString(index)))) {
                return new JSONReference(this.base, newTokens, true, (JSONValue)mapping.get((Object)name));
            }
        }
        return new JSONReference(this.base, newTokens, false, null);
    }

    public JSONReference locateChild(JSONValue target) {
        block4: {
            block3: {
                if (this.value == target) {
                    return this;
                }
                if (!(this.value instanceof JSONMapping)) break block3;
                JSONMapping mapping = (JSONMapping)this.value;
                for (String key : mapping.keySet()) {
                    JSONReference nested = this.child(key).locateChild(target);
                    if (nested == null) continue;
                    return nested;
                }
                break block4;
            }
            if (!(this.value instanceof JSONSequence)) break block4;
            JSONSequence sequence = (JSONSequence)this.value;
            int n = sequence.size();
            for (int i = 0; i < n; ++i) {
                JSONReference nested = this.child(i).locateChild(target);
                if (nested == null) continue;
                return nested;
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONReference) || !super.equals(other)) {
            return false;
        }
        JSONReference otherRef = (JSONReference)other;
        return this.base == otherRef.base && this.valid == otherRef.valid && this.value == otherRef.value;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.base) ^ (this.valid ? 1 : 0) ^ Objects.hashCode(this.value);
    }

    @Override
    public String toString() {
        return this.valid ? (this.value == null ? "null" : this.value.toJSON()) : "invalid";
    }
}

