/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.time.Clock;
import net.pwall.log.Level;
import net.pwall.log.Logger;

public interface LoggerFactory<L extends Logger> {
    public static final String logPackageName = LoggerFactory.class.getPackage().getName();
    public static final Clock systemClock = Clock.systemDefaultZone();

    public L getLogger(String var1, Level var2, Clock var3);

    default public L getLogger(String name, Level level) {
        return this.getLogger(name, level, this.getDefaultClock());
    }

    default public L getLogger(String name, Clock clock) {
        return this.getLogger(name, this.getDefaultLevel(), clock);
    }

    default public L getLogger(String name) {
        return this.getLogger(name, this.getDefaultLevel(), this.getDefaultClock());
    }

    default public L getLogger(Class<?> javaClass, Level level, Clock clock) {
        return this.getLogger(javaClass.getName(), level, clock);
    }

    default public L getLogger(Class<?> javaClass, Level level) {
        return this.getLogger(javaClass.getName(), level, this.getDefaultClock());
    }

    default public L getLogger(Class<?> javaClass, Clock clock) {
        return this.getLogger(javaClass.getName(), this.getDefaultLevel(), clock);
    }

    default public L getLogger(Class<?> javaClass) {
        return this.getLogger(javaClass.getName(), this.getDefaultLevel(), this.getDefaultClock());
    }

    default public L getLogger() {
        return this.getLogger(LoggerFactory.callerInfo().getClassName(), this.getDefaultLevel(), this.getDefaultClock());
    }

    default public L getLogger(Level level, Clock clock) {
        return this.getLogger(LoggerFactory.callerInfo().getClassName(), level, clock);
    }

    default public L getLogger(Level level) {
        return this.getLogger(LoggerFactory.callerInfo().getClassName(), level, this.getDefaultClock());
    }

    default public L getLogger(Clock clock) {
        return this.getLogger(LoggerFactory.callerInfo().getClassName(), this.getDefaultLevel(), clock);
    }

    default public Level getDefaultLevel() {
        return Level.INFO;
    }

    default public Clock getDefaultClock() {
        return systemClock;
    }

    public static StackTraceElement callerInfo() {
        StackTraceElement[] callStack = new Throwable().getStackTrace();
        int packageNameLength = logPackageName.length();
        int n = callStack.length;
        for (int i = 2; i < n; ++i) {
            StackTraceElement element = callStack[i];
            String className = element.getClassName();
            if (className.lastIndexOf(46) == packageNameLength && className.startsWith(logPackageName)) continue;
            return element;
        }
        return new StackTraceElement("unknown", "unknown", null, -1);
    }
}

