/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import net.pwall.log.Level;
import net.pwall.log.Log;
import net.pwall.log.LogItem;
import net.pwall.log.Logger;
import net.pwall.log.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u001a\u001a\u0010\u0000\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0000\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\u0000\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a?\u0010\u0000\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\f0\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u001a\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\u0015\u0010\u0016\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u0016\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u00a8\u0006\u0019"}, d2={"getLogger", "Lnet/pwall/log/Logger;", "javaClass", "Ljava/lang/Class;", "clock", "Ljava/time/Clock;", "level", "Lnet/pwall/log/Level;", "name", "", "kClass", "Lkotlin/reflect/KClass;", "L", "Lnet/pwall/log/LoggerFactory;", "(Lnet/pwall/log/LoggerFactory;Lkotlin/reflect/KClass;Lnet/pwall/log/Level;Ljava/time/Clock;)Lnet/pwall/log/Logger;", "isDebug", "", "Lnet/pwall/log/LogItem;", "text", "regex", "Lkotlin/text/Regex;", "isError", "isInfo", "isTrace", "isWarning", "log-front-kotlin"})
public final class LoggerUtilKt {
    @NotNull
    public static final Logger getLogger() {
        Logger logger = Log.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger()");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Logger logger = Log.getLogger((Level)level);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(level)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Level level, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((Level)level, (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(level, clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Logger logger = Log.getLogger((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull String name, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Logger logger = Log.getLogger((String)name, (Level)level);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name, level)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull String name, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((String)name, (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name, clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull String name, @NotNull Level level, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((String)name, (Level)level, (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name, level, clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Class<?> javaClass) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Logger logger = Log.getLogger((String)javaClass.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass.name)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Class<?> javaClass, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Logger logger = Log.getLogger((String)javaClass.getName(), (Level)level);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass.name, level)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Class<?> javaClass, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((String)javaClass.getName(), (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass.name, clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull Class<?> javaClass, @NotNull Level level, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((String)javaClass.getName(), (Level)level, (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass.name, level, clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Logger logger = Log.getLogger((String)kClass.getQualifiedName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(kClass.qualifiedName)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull KClass<?> kClass, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Logger logger = Log.getLogger((String)kClass.getQualifiedName(), (Level)level);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(kClass.qualifiedName, level)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull KClass<?> kClass, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((String)kClass.getQualifiedName(), (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(kClass.qualifiedName, clock)");
        return logger;
    }

    @NotNull
    public static final Logger getLogger(@NotNull KClass<?> kClass, @NotNull Level level, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = Log.getLogger((String)kClass.getQualifiedName(), (Level)level, (Clock)clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(kClass.qualifiedName, level, clock)");
        return logger;
    }

    @NotNull
    public static final <L extends Logger> L getLogger(@NotNull LoggerFactory<L> $this$getLogger, @NotNull KClass<?> kClass, @NotNull Level level, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter($this$getLogger, (String)"<this>");
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Logger logger = $this$getLogger.getLogger(kClass.getQualifiedName(), level, clock);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(kClass.qualifiedName, level, clock)");
        return (L)logger;
    }

    public static /* synthetic */ Logger getLogger$default(LoggerFactory loggerFactory, KClass kClass, Level level, Clock clock, int n, Object object) {
        Object object2;
        if ((n & 2) != 0) {
            object2 = loggerFactory.getDefaultLevel();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fun <L : Logger> LoggerF\u2026lifiedName, level, clock)");
            level = object2;
        }
        if ((n & 4) != 0) {
            object2 = loggerFactory.getDefaultClock();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fun <L : Logger> LoggerF\u2026lifiedName, level, clock)");
            clock = object2;
        }
        return LoggerUtilKt.getLogger(loggerFactory, kClass, level, clock);
    }

    public static final boolean isTrace(@NotNull LogItem $this$isTrace, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrace, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return $this$isTrace.getLevel() == Level.TRACE && Intrinsics.areEqual((Object)$this$isTrace.getMessage(), (Object)text);
    }

    public static final boolean isTrace(@NotNull LogItem $this$isTrace, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrace, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return $this$isTrace.getLevel() == Level.TRACE && regex.containsMatchIn((CharSequence)$this$isTrace.getMessage().toString());
    }

    public static final boolean isDebug(@NotNull LogItem $this$isDebug, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return $this$isDebug.getLevel() == Level.DEBUG && Intrinsics.areEqual((Object)$this$isDebug.getMessage(), (Object)text);
    }

    public static final boolean isDebug(@NotNull LogItem $this$isDebug, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)$this$isDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return $this$isDebug.getLevel() == Level.DEBUG && regex.containsMatchIn((CharSequence)$this$isDebug.getMessage().toString());
    }

    public static final boolean isInfo(@NotNull LogItem $this$isInfo, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$isInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return $this$isInfo.getLevel() == Level.INFO && Intrinsics.areEqual((Object)$this$isInfo.getMessage(), (Object)text);
    }

    public static final boolean isInfo(@NotNull LogItem $this$isInfo, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)$this$isInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return $this$isInfo.getLevel() == Level.INFO && regex.containsMatchIn((CharSequence)$this$isInfo.getMessage().toString());
    }

    public static final boolean isWarning(@NotNull LogItem $this$isWarning, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$isWarning, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return $this$isWarning.getLevel() == Level.WARN && Intrinsics.areEqual((Object)$this$isWarning.getMessage(), (Object)text);
    }

    public static final boolean isWarning(@NotNull LogItem $this$isWarning, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)$this$isWarning, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return $this$isWarning.getLevel() == Level.WARN && regex.containsMatchIn((CharSequence)$this$isWarning.getMessage().toString());
    }

    public static final boolean isError(@NotNull LogItem $this$isError, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)$this$isError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return $this$isError.getLevel() == Level.ERROR && Intrinsics.areEqual((Object)$this$isError.getMessage(), (Object)text);
    }

    public static final boolean isError(@NotNull LogItem $this$isError, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)$this$isError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return $this$isError.getLevel() == Level.ERROR && regex.containsMatchIn((CharSequence)$this$isError.getMessage().toString());
    }
}

