/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import net.pwall.log.Level;
import net.pwall.log.Logger;
import net.pwall.log.LoggerException;
import net.pwall.log.LoggerFactory;

public abstract class AbstractLoggerFactory<L extends Logger>
implements LoggerFactory<L> {
    public static final String defaultLevelPropertyName = "net.pwall.log.defaultLevel";
    public static final Level systemDefaultLevel;
    private Level defaultLevel;
    private Clock defaultClock;
    private final Map<String, L> loggerCache = new HashMap<String, L>();

    protected AbstractLoggerFactory(Level defaultLevel, Clock defaultClock) {
        this.defaultLevel = defaultLevel;
        this.defaultClock = defaultClock;
    }

    public Level getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Level defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    public Clock getDefaultClock() {
        return this.defaultClock;
    }

    public void setDefaultClock(Clock defaultClock) {
        this.defaultClock = defaultClock;
    }

    protected synchronized L getCachedLogger(String name) {
        if (name == null) {
            throw new LoggerException("Logger name must not be null");
        }
        int n = name.length();
        if (n == 0) {
            throw new LoggerException("Logger name must not be empty");
        }
        for (int i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if (ch >= ' ' && ch <= '\u00fe') continue;
            throw new LoggerException("Illegal character in Logger name");
        }
        return (L)((Logger)this.loggerCache.get(name));
    }

    protected synchronized void putCachedLogger(String name, L logger) {
        this.loggerCache.put(name, logger);
    }

    static {
        Level level = Level.INFO;
        String env = System.getProperty(defaultLevelPropertyName);
        if (env != null) {
            try {
                level = Level.valueOf((String)env.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        systemDefaultLevel = level;
    }
}

