/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.IntConsumer;
import net.pwall.log.AbstractFormatter;
import net.pwall.log.AbstractLogger;
import net.pwall.log.Level;
import net.pwall.log.Logger;

public class BasicFormatter
extends AbstractFormatter {
    public static final int defaultNameLengthLimit = 40;
    private int nameLengthLimit = 40;
    private boolean colouredLevel = true;

    @Override
    public void format(long millis, Logger logger, Level level, Object message, Throwable throwable, IntConsumer outFunction) {
        int dayMillis = BasicFormatter.getDayMillis(millis, logger.getClock().getZone());
        this.outputMessage(dayMillis, logger, level, message.toString(), outFunction);
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            this.outputMessage(dayMillis, logger, level, sw.toString(), outFunction);
        }
    }

    private void outputMessage(int dayMillis, Logger logger, Level level, String text, IntConsumer outFunction) {
        AbstractLogger.outputMultiLine(text, line -> {
            BasicFormatter.outputTime(dayMillis, outFunction);
            outFunction.accept(32);
            if (this.colouredLevel) {
                BasicFormatter.outputLevel5Coloured(level, outFunction);
            } else {
                BasicFormatter.outputLevel5(level, outFunction);
            }
            outFunction.accept(32);
            BasicFormatter.outputNameWithLimit(this.nameLengthLimit, logger.getName(), outFunction);
            outFunction.accept(58);
            outFunction.accept(32);
            BasicFormatter.outputText(line, outFunction);
            outFunction.accept(10);
        });
    }

    public int getNameLengthLimit() {
        return this.nameLengthLimit;
    }

    public void setNameLengthLimit(int nameLengthLimit) {
        this.nameLengthLimit = Math.max(nameLengthLimit, 8);
    }

    public boolean isColouredLevel() {
        return this.colouredLevel;
    }

    public void setColouredLevel(boolean colouredLevel) {
        this.colouredLevel = colouredLevel;
    }
}

