/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.io.PrintStream;
import java.time.Clock;
import java.util.Objects;
import net.pwall.log.AbstractLoggerFactory;
import net.pwall.log.ConsoleLogger;
import net.pwall.log.Level;

public class ConsoleLoggerFactory
extends AbstractLoggerFactory<ConsoleLogger> {
    private static final ConsoleLoggerFactory instance = new ConsoleLoggerFactory();
    private PrintStream output;

    public ConsoleLoggerFactory(Level defaultLevel, Clock defaultClock, PrintStream output) {
        super(defaultLevel, defaultClock);
        this.setOutput(output);
    }

    public ConsoleLoggerFactory(Level defaultLevel, PrintStream output) {
        this(defaultLevel, systemClock, output);
    }

    public ConsoleLoggerFactory(PrintStream output) {
        this(systemDefaultLevel, systemClock, output);
    }

    public ConsoleLoggerFactory(Level defaultLevel) {
        this(defaultLevel, systemClock, ConsoleLogger.defaultOutput);
    }

    public ConsoleLoggerFactory() {
        this(systemDefaultLevel, systemClock, ConsoleLogger.defaultOutput);
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setOutput(PrintStream output) {
        this.output = Objects.requireNonNull(output);
    }

    public ConsoleLogger getLogger(String name, Level level, Clock clock) {
        ConsoleLogger logger = (ConsoleLogger)this.getCachedLogger(name);
        if (logger != null) {
            return logger;
        }
        logger = new ConsoleLogger(name, level, clock, this.output);
        this.putCachedLogger(name, logger);
        return logger;
    }

    public static ConsoleLoggerFactory getInstance() {
        return instance;
    }
}

