/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.time.Clock;
import net.pwall.log.AbstractLoggerFactory;
import net.pwall.log.FormattingLoggerFactory;
import net.pwall.log.JavaLogger;
import net.pwall.log.Level;
import net.pwall.log.Logger;
import net.pwall.log.Slf4jLogger;
import net.pwall.log.Slf4jProxy;

public class DynamicLoggerFactory
extends AbstractLoggerFactory<Logger> {
    private static Slf4jProxy slf4jProxy = null;
    private static boolean javaLogging = false;
    private FormattingLoggerFactory<?, ?> formattingLoggerFactory = null;

    public DynamicLoggerFactory(Level defaultLevel, Clock defaultClock) {
        super(defaultLevel, defaultClock);
    }

    public DynamicLoggerFactory(Level defaultLevel) {
        super(defaultLevel, systemClock);
    }

    public DynamicLoggerFactory(Clock defaultClock) {
        super(systemDefaultLevel, defaultClock);
    }

    public DynamicLoggerFactory() {
        super(systemDefaultLevel, systemClock);
    }

    public Logger getLogger(String name, Level level, Clock clock) {
        Object logger = this.getCachedLogger(name);
        if (logger != null) {
            return logger;
        }
        logger = this.getSpecificLogger(name, level, clock);
        this.putCachedLogger(name, logger);
        return logger;
    }

    private Logger getSpecificLogger(String name, Level level, Clock clock) {
        if (slf4jProxy != null) {
            try {
                return new Slf4jLogger(name, level, clock, slf4jProxy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (javaLogging) {
            return new JavaLogger(name, level, clock);
        }
        return this.getFormattingLoggerFactory().getLogger(name, level, clock);
    }

    private synchronized FormattingLoggerFactory<?, ?> getFormattingLoggerFactory() {
        if (this.formattingLoggerFactory == null) {
            this.formattingLoggerFactory = FormattingLoggerFactory.getBasic();
        }
        return this.formattingLoggerFactory;
    }

    static {
        try {
            slf4jProxy = new Slf4jProxy();
        }
        catch (Exception ignore) {
            javaLogging = System.getProperty("java.util.logging.config.file") != null || DynamicLoggerFactory.class.getResource("logging.properties") != null;
        }
    }
}

