/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.io.PrintStream;
import java.time.Clock;
import net.pwall.log.AbstractLoggerFactory;
import net.pwall.log.BasicFormatter;
import net.pwall.log.FormattingLogger;
import net.pwall.log.Level;
import net.pwall.log.LogAppender;
import net.pwall.log.LogFormatter;
import net.pwall.log.PrintStreamAppender;

public class FormattingLoggerFactory<F extends LogFormatter, A extends LogAppender<F>>
extends AbstractLoggerFactory<FormattingLogger<F, A>> {
    private final A appender;

    public FormattingLoggerFactory(A appender) {
        super(systemDefaultLevel, systemClock);
        this.appender = appender;
    }

    public FormattingLogger<F, A> getLogger(String name, Level level, Clock clock) {
        FormattingLogger logger = (FormattingLogger)this.getCachedLogger(name);
        if (logger != null) {
            return logger;
        }
        logger = new FormattingLogger(name, this.appender, level, clock);
        this.putCachedLogger(name, logger);
        return logger;
    }

    public static FormattingLoggerFactory<BasicFormatter, PrintStreamAppender<BasicFormatter>> getBasic(PrintStream printStream) {
        return new FormattingLoggerFactory<BasicFormatter, PrintStreamAppender<BasicFormatter>>(PrintStreamAppender.getBasic(printStream));
    }

    public static FormattingLoggerFactory<BasicFormatter, PrintStreamAppender<BasicFormatter>> getBasic() {
        return new FormattingLoggerFactory<BasicFormatter, PrintStreamAppender<BasicFormatter>>(PrintStreamAppender.getBasic());
    }

    public static <FF extends LogFormatter> FormattingLoggerFactory<FF, PrintStreamAppender<FF>> getFactory(FF formatter) {
        return new FormattingLoggerFactory(new PrintStreamAppender<FF>(formatter));
    }

    public static <FF extends LogFormatter> FormattingLoggerFactory<FF, PrintStreamAppender<FF>> getFactory(PrintStream printStream, FF formatter) {
        return new FormattingLoggerFactory(new PrintStreamAppender<FF>(printStream, formatter));
    }

    public static <FF extends LogFormatter, AA extends LogAppender<FF>> FormattingLoggerFactory<FF, AA> getFactory(AA appender) {
        return new FormattingLoggerFactory(appender);
    }
}

