/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.time.Clock;
import net.pwall.log.AbstractLoggerFactory;
import net.pwall.log.JavaLogger;
import net.pwall.log.Level;

public class JavaLoggerFactory
extends AbstractLoggerFactory<JavaLogger> {
    private static final JavaLoggerFactory instance = new JavaLoggerFactory();

    public JavaLoggerFactory() {
        super(systemDefaultLevel, systemClock);
    }

    public JavaLogger getLogger(String name, Level level, Clock clock) {
        JavaLogger logger = (JavaLogger)this.getCachedLogger(name);
        if (logger != null) {
            return logger;
        }
        logger = new JavaLogger(name, level, clock);
        this.putCachedLogger(name, logger);
        return logger;
    }

    public static JavaLoggerFactory getInstance() {
        return instance;
    }

    public static JavaLogger getJavaLogger(String name) {
        return (JavaLogger)JavaLoggerFactory.getInstance().getLogger(name);
    }

    public static JavaLogger getJavaLogger(Class<?> javaClass) {
        return (JavaLogger)JavaLoggerFactory.getInstance().getLogger(javaClass.getName());
    }
}

