/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.util.ArrayList;
import java.util.List;
import net.pwall.log.Level;
import net.pwall.log.Logger;

public abstract class LogListener
implements AutoCloseable {
    private static final List<LogListener> listeners = new ArrayList<LogListener>();
    private static final LogListener[] emptyArray = new LogListener[0];

    public LogListener() {
        LogListener.add(this);
    }

    @Override
    public void close() {
        LogListener.remove(this);
    }

    public abstract void receive(long var1, Logger var3, Level var4, Object var5, Throwable var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(LogListener listener) {
        List<LogListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(LogListener listener) {
        List<LogListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    public static boolean present() {
        return listeners.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAll(long time, Logger logger, Level level, Object message, Throwable throwable) {
        LogListener single = null;
        LogListener[] array = emptyArray;
        LogListener[] logListenerArray = listeners;
        synchronized (listeners) {
            int n = listeners.size();
            if (n == 1) {
                single = listeners.get(0);
            } else if (n > 1) {
                array = new LogListener[n];
                array = listeners.toArray(array);
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            if (single != null) {
                single.receive(time, logger, level, message, throwable);
            } else {
                for (LogListener listener : array) {
                    listener.receive(time, logger, level, message, throwable);
                }
            }
            return;
        }
    }
}

