/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.io.PrintStream;
import java.util.function.IntConsumer;
import net.pwall.log.BasicFormatter;
import net.pwall.log.Level;
import net.pwall.log.LogAppender;
import net.pwall.log.LogFormatter;
import net.pwall.log.Logger;
import net.pwall.log.LoggerException;

public class PrintStreamAppender<F extends LogFormatter>
implements LogAppender<F>,
IntConsumer {
    public static final PrintStream defaultOutput = System.out;
    private final PrintStream stream;
    private final F formatter;

    public PrintStreamAppender(PrintStream stream, F formatter) {
        this.stream = stream;
        this.formatter = formatter;
    }

    public PrintStreamAppender(F formatter) {
        this(defaultOutput, formatter);
    }

    @Override
    public F getFormatter() {
        return this.formatter;
    }

    @Override
    public synchronized void output(long millis, Logger logger, Level level, Object message, Throwable throwable) {
        this.formatter.format(millis, logger, level, message, throwable, this);
    }

    @Override
    public void accept(int ch) {
        if (ch == 10) {
            this.stream.println();
            if (this.stream.checkError()) {
                throw new LoggerException("Error writing PrintStreamAppender");
            }
        } else {
            this.stream.print((char)ch);
        }
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public static PrintStreamAppender<BasicFormatter> getBasic(PrintStream stream) {
        return new PrintStreamAppender<BasicFormatter>(stream, new BasicFormatter());
    }

    public static PrintStreamAppender<BasicFormatter> getBasic() {
        return new PrintStreamAppender<BasicFormatter>(defaultOutput, new BasicFormatter());
    }
}

