/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.lang.reflect.InvocationTargetException;
import java.time.Clock;
import java.util.function.Supplier;
import net.pwall.log.AbstractLogger;
import net.pwall.log.Level;
import net.pwall.log.LogListener;
import net.pwall.log.Slf4jProxy;

public class Slf4jLogger
extends AbstractLogger {
    private final Slf4jProxy slf4jProxy;
    private final Object slf4jLogger;

    Slf4jLogger(String name, Level level, Clock clock, Slf4jProxy slf4jProxy) throws InvocationTargetException, IllegalAccessException {
        super(name, level, clock);
        this.slf4jProxy = slf4jProxy;
        this.slf4jLogger = slf4jProxy.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return this.slf4jProxy.isTraceEnabled(this.slf4jLogger);
    }

    public boolean isDebugEnabled() {
        return this.slf4jProxy.isDebugEnabled(this.slf4jLogger);
    }

    public boolean isInfoEnabled() {
        return this.slf4jProxy.isInfoEnabled(this.slf4jLogger);
    }

    public boolean isWarnEnabled() {
        return this.slf4jProxy.isWarnEnabled(this.slf4jLogger);
    }

    public boolean isErrorEnabled() {
        return this.slf4jProxy.isErrorEnabled(this.slf4jLogger);
    }

    public boolean isEnabled(Level level) {
        return this.slf4jProxy.isEnabled(this.slf4jLogger, level);
    }

    public void trace(Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.TRACE, text, null);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.trace(this.slf4jLogger, (String)s));
    }

    public void debug(Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.DEBUG, text, null);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.debug(this.slf4jLogger, (String)s));
    }

    public void info(Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.INFO, text, null);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.info(this.slf4jLogger, (String)s));
    }

    public void warn(Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.WARN, text, null);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.warn(this.slf4jLogger, (String)s));
    }

    public void error(Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.ERROR, text, null);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.error(this.slf4jLogger, (String)s));
    }

    public void error(Throwable throwable, Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.ERROR, text, throwable);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.error(this.slf4jLogger, (String)s, throwable));
    }

    public void log(Level level, Object message) {
        String text = String.valueOf(message);
        if (LogListener.present()) {
            LogListener.invokeAll(this.getClock().millis(), this, Level.ERROR, text, null);
        }
        Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.log(this.slf4jLogger, level, (String)s));
    }

    public void log(Level level, Supplier<Object> messageSupplier) {
        if (this.isEnabled(level)) {
            String text = String.valueOf(messageSupplier.get());
            if (LogListener.present()) {
                LogListener.invokeAll(this.getClock().millis(), this, level, text, null);
            }
            Slf4jLogger.outputMultiLine(text, s -> this.slf4jProxy.log(this.slf4jLogger, level, (String)s));
        }
    }
}

