/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.pwall.log.Level;
import net.pwall.log.Slf4jLoggerException;

public class Slf4jProxy {
    private final Method getLoggerMethod;
    private final Method isTraceEnabledMethod;
    private final Method isDebugEnabledMethod;
    private final Method isInfoEnabledMethod;
    private final Method isWarnEnabledMethod;
    private final Method isErrorEnabledMethod;
    private final Method traceMethod;
    private final Method debugMethod;
    private final Method infoMethod;
    private final Method warnMethod;
    private final Method errorMethod;
    private final Method errorThrowableMethod;
    private final Method[] dynamicIsEnabledMethods;
    private final Method[] dynamicLogMethods;

    public Slf4jProxy() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
        this.getLoggerMethod = loggerFactoryClass.getMethod("getLogger", String.class);
        Class<?> loggerClass = Class.forName("org.slf4j.Logger");
        this.isTraceEnabledMethod = loggerClass.getMethod("isTraceEnabled", new Class[0]);
        this.isDebugEnabledMethod = loggerClass.getMethod("isDebugEnabled", new Class[0]);
        this.isInfoEnabledMethod = loggerClass.getMethod("isInfoEnabled", new Class[0]);
        this.isWarnEnabledMethod = loggerClass.getMethod("isWarnEnabled", new Class[0]);
        this.isErrorEnabledMethod = loggerClass.getMethod("isErrorEnabled", new Class[0]);
        this.traceMethod = loggerClass.getMethod("trace", String.class);
        this.debugMethod = loggerClass.getMethod("debug", String.class);
        this.infoMethod = loggerClass.getMethod("info", String.class);
        this.warnMethod = loggerClass.getMethod("warn", String.class);
        this.errorMethod = loggerClass.getMethod("error", String.class);
        this.errorThrowableMethod = loggerClass.getMethod("error", String.class, Throwable.class);
        this.dynamicIsEnabledMethods = new Method[]{this.isTraceEnabledMethod, this.isDebugEnabledMethod, this.isInfoEnabledMethod, this.isWarnEnabledMethod, this.isErrorEnabledMethod};
        this.dynamicLogMethods = new Method[]{this.traceMethod, this.debugMethod, this.infoMethod, this.warnMethod, this.errorMethod};
    }

    public Object getLogger(String name) throws InvocationTargetException, IllegalAccessException {
        return this.getLoggerMethod.invoke(null, name);
    }

    public boolean isTraceEnabled(Object slf4jLogger) {
        try {
            return (Boolean)this.isTraceEnabledMethod.invoke(slf4jLogger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public boolean isDebugEnabled(Object slf4jLogger) {
        try {
            return (Boolean)this.isDebugEnabledMethod.invoke(slf4jLogger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public boolean isInfoEnabled(Object slf4jLogger) {
        try {
            return (Boolean)this.isInfoEnabledMethod.invoke(slf4jLogger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public boolean isWarnEnabled(Object slf4jLogger) {
        try {
            return (Boolean)this.isWarnEnabledMethod.invoke(slf4jLogger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public boolean isErrorEnabled(Object slf4jLogger) {
        try {
            return (Boolean)this.isErrorEnabledMethod.invoke(slf4jLogger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public boolean isEnabled(Object slf4jLogger, Level level) {
        try {
            return (Boolean)this.dynamicIsEnabledMethods[level.ordinal()].invoke(slf4jLogger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void trace(Object slf4jLogger, String text) {
        try {
            this.traceMethod.invoke(slf4jLogger, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void debug(Object slf4jLogger, String text) {
        try {
            this.debugMethod.invoke(slf4jLogger, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void info(Object slf4jLogger, String text) {
        try {
            this.infoMethod.invoke(slf4jLogger, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void warn(Object slf4jLogger, String text) {
        try {
            this.warnMethod.invoke(slf4jLogger, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void error(Object slf4jLogger, String text) {
        try {
            this.errorMethod.invoke(slf4jLogger, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void error(Object slf4jLogger, String text, Throwable throwable) {
        try {
            this.errorThrowableMethod.invoke(slf4jLogger, text, throwable);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }

    public void log(Object slf4jLogger, Level level, String text) {
        try {
            this.dynamicLogMethods[level.ordinal()].invoke(slf4jLogger, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Slf4jLoggerException(e);
        }
    }
}

