/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.IOException;
import java.util.function.IntConsumer;

public class IntOutput {
    public static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] tensDigits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] digitsHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] digitsHexLC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String MIN_INTEGER_STRING = "-2147483648";
    public static final String MIN_LONG_STRING = "-9223372036854775808";

    public static void appendInt(Appendable a, int i) throws IOException {
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                a.append(MIN_INTEGER_STRING);
            } else {
                a.append('-');
                IntOutput.appendPositiveInt(a, -i);
            }
        } else {
            IntOutput.appendPositiveInt(a, i);
        }
    }

    public static void appendPositiveInt(Appendable a, int i) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveInt(a, n);
            a.append(tensDigits[i -= n * 100]);
            a.append(digits[i]);
        } else if (i >= 10) {
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            a.append(digits[i]);
        }
    }

    public static void appendUnsignedInt(Appendable a, int i) throws IOException {
        if (i >= 0) {
            IntOutput.appendPositiveInt(a, i);
        } else {
            int n = (i >>> 1) / 50;
            IntOutput.appendPositiveInt(a, n);
            a.append(tensDigits[i -= n * 100]);
            a.append(digits[i]);
        }
    }

    public static void appendLong(Appendable a, long n) throws IOException {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                a.append(MIN_LONG_STRING);
            } else {
                a.append('-');
                IntOutput.appendPositiveLong(a, -n);
            }
        } else {
            IntOutput.appendPositiveLong(a, n);
        }
    }

    public static void appendPositiveLong(Appendable a, long n) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLong(a, m);
            int i = (int)(n - m * 100L);
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    public static void appendUnsignedLong(Appendable a, long n) throws IOException {
        if (n >= 0L) {
            IntOutput.appendPositiveLong(a, n);
        } else {
            long m = (n >>> 1) / 50L;
            IntOutput.appendPositiveLong(a, m);
            int i = (int)(n - m * 100L);
            a.append(tensDigits[i]);
            a.append(digits[i]);
        }
    }

    public static void append2Digits(Appendable a, int i) throws IOException {
        a.append(tensDigits[i]);
        a.append(digits[i]);
    }

    public static void append3Digits(Appendable a, int i) throws IOException {
        int n = i / 100;
        a.append(digits[n]);
        IntOutput.append2Digits(a, i - n * 100);
    }

    public static void appendIntGrouped(Appendable a, int i, char groupingChar) throws IOException {
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                a.append(MIN_INTEGER_STRING, 0, 2);
                a.append(groupingChar);
                a.append(MIN_INTEGER_STRING, 2, 5);
                a.append(groupingChar);
                a.append(MIN_INTEGER_STRING, 5, 8);
                a.append(groupingChar);
                a.append(MIN_INTEGER_STRING, 8, 11);
            } else {
                a.append('-');
                IntOutput.appendPositiveIntGrouped(a, -i, groupingChar);
            }
        } else {
            IntOutput.appendPositiveIntGrouped(a, i, groupingChar);
        }
    }

    public static void appendPositiveIntGrouped(Appendable a, int i, char groupingChar) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveIntGrouped1(a, n, groupingChar);
            a.append(tensDigits[i -= n * 100]);
            a.append(digits[i]);
        } else if (i >= 10) {
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            a.append(digits[i]);
        }
    }

    private static void appendPositiveIntGrouped1(Appendable a, int i, char groupingChar) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveIntGrouped2(a, n, groupingChar);
            a.append(tensDigits[i -= n * 100]);
            a.append(groupingChar);
            a.append(digits[i]);
        } else if (i >= 10) {
            a.append(tensDigits[i]);
            a.append(groupingChar);
            a.append(digits[i]);
        } else {
            a.append(digits[i]);
        }
    }

    private static void appendPositiveIntGrouped2(Appendable a, int i, char groupingChar) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveIntGrouped(a, n, groupingChar);
            a.append(groupingChar);
            a.append(tensDigits[i -= n * 100]);
            a.append(digits[i]);
        } else if (i >= 10) {
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            a.append(digits[i]);
        }
    }

    public static void appendLongGrouped(Appendable a, long n, char groupingChar) throws IOException {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                a.append(MIN_LONG_STRING, 0, 2);
                a.append(groupingChar);
                a.append(MIN_LONG_STRING, 2, 5);
                a.append(groupingChar);
                a.append(MIN_LONG_STRING, 5, 8);
                a.append(groupingChar);
                a.append(MIN_LONG_STRING, 8, 11);
                a.append(groupingChar);
                a.append(MIN_LONG_STRING, 11, 14);
                a.append(groupingChar);
                a.append(MIN_LONG_STRING, 14, 17);
                a.append(groupingChar);
                a.append(MIN_LONG_STRING, 17, 20);
            } else {
                a.append('-');
                IntOutput.appendPositiveLongGrouped(a, -n, groupingChar);
            }
        } else {
            IntOutput.appendPositiveLongGrouped(a, n, groupingChar);
        }
    }

    public static void appendPositiveLongGrouped(Appendable a, long n, char groupingChar) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLongGrouped1(a, m, groupingChar);
            int i = (int)(n - m * 100L);
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    private static void appendPositiveLongGrouped1(Appendable a, long n, char groupingChar) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLongGrouped2(a, m, groupingChar);
            int i = (int)(n - m * 100L);
            a.append(tensDigits[i]);
            a.append(groupingChar);
            a.append(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
                a.append(groupingChar);
            }
            a.append(digits[i]);
        }
    }

    private static void appendPositiveLongGrouped2(Appendable a, long n, char groupingChar) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLongGrouped(a, m, groupingChar);
            int i = (int)(n - m * 100L);
            a.append(groupingChar);
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    public static void appendIntHex(Appendable a, int i) throws IOException {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.append16BitsHex(a, i >>> 16);
            IntOutput.append4Hex(a, i);
        } else {
            IntOutput.append16BitsHex(a, i);
        }
    }

    private static void append8BitsHex(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFFF0) != 0) {
            a.append(digitsHex[i >>> 4]);
        }
        a.append(digitsHex[i & 0xF]);
    }

    private static void append16BitsHex(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.append8BitsHex(a, i >>> 8);
            IntOutput.append2Hex(a, i);
        } else {
            IntOutput.append8BitsHex(a, i);
        }
    }

    public static void appendIntHexLC(Appendable a, int i) throws IOException {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.append16BitsHexLC(a, i >>> 16);
            IntOutput.append4HexLC(a, i);
        } else {
            IntOutput.append16BitsHexLC(a, i);
        }
    }

    private static void append8BitsHexLC(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFFF0) != 0) {
            a.append(digitsHexLC[i >>> 4]);
        }
        a.append(digitsHexLC[i & 0xF]);
    }

    private static void append16BitsHexLC(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.append8BitsHexLC(a, i >>> 8);
            IntOutput.append2HexLC(a, i);
        } else {
            IntOutput.append8BitsHexLC(a, i);
        }
    }

    public static void appendLongHex(Appendable a, long n) throws IOException {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.appendIntHex(a, hi);
            IntOutput.append8Hex(a, lo);
        } else {
            IntOutput.appendIntHex(a, lo);
        }
    }

    public static void appendLongHexLC(Appendable a, long n) throws IOException {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.appendIntHexLC(a, hi);
            IntOutput.append8HexLC(a, lo);
        } else {
            IntOutput.appendIntHexLC(a, lo);
        }
    }

    public static void append8Hex(Appendable a, int i) throws IOException {
        IntOutput.append4Hex(a, i >>> 16);
        IntOutput.append4Hex(a, i);
    }

    public static void append8HexLC(Appendable a, int i) throws IOException {
        IntOutput.append4HexLC(a, i >>> 16);
        IntOutput.append4HexLC(a, i);
    }

    public static void append4Hex(Appendable a, int i) throws IOException {
        IntOutput.append2Hex(a, i >>> 8);
        IntOutput.append2Hex(a, i);
    }

    public static void append4HexLC(Appendable a, int i) throws IOException {
        IntOutput.append2HexLC(a, i >>> 8);
        IntOutput.append2HexLC(a, i);
    }

    public static void append2Hex(Appendable a, int i) throws IOException {
        a.append(digitsHex[i >> 4 & 0xF]);
        a.append(digitsHex[i & 0xF]);
    }

    public static void append2HexLC(Appendable a, int i) throws IOException {
        a.append(digitsHexLC[i >> 4 & 0xF]);
        a.append(digitsHexLC[i & 0xF]);
    }

    public static void append1Hex(Appendable a, int i) throws IOException {
        a.append(digitsHex[i & 0xF]);
    }

    public static void append1HexLC(Appendable a, int i) throws IOException {
        a.append(digitsHexLC[i & 0xF]);
    }

    public static void outputInt(int i, IntConsumer consumer) {
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                IntOutput.outputString(MIN_INTEGER_STRING, consumer);
            } else {
                consumer.accept(45);
                IntOutput.outputPositiveInt(-i, consumer);
            }
        } else {
            IntOutput.outputPositiveInt(i, consumer);
        }
    }

    public static void outputPositiveInt(int i, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveInt(n, consumer);
            consumer.accept(tensDigits[i -= n * 100]);
            consumer.accept(digits[i]);
        } else if (i >= 10) {
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        } else {
            consumer.accept(digits[i]);
        }
    }

    public static void outputUnsignedInt(int i, IntConsumer consumer) {
        if (i >= 0) {
            IntOutput.outputPositiveInt(i, consumer);
        } else {
            int n = (i >>> 1) / 50;
            IntOutput.outputPositiveInt(n, consumer);
            consumer.accept(tensDigits[i -= n * 100]);
            consumer.accept(digits[i]);
        }
    }

    public static void outputLong(long n, IntConsumer consumer) {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                IntOutput.outputString(MIN_LONG_STRING, consumer);
            } else {
                consumer.accept(45);
                IntOutput.outputPositiveLong(-n, consumer);
            }
        } else {
            IntOutput.outputPositiveLong(n, consumer);
        }
    }

    public static void outputPositiveLong(long n, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLong(m, consumer);
            int i = (int)(n - m * 100L);
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    public static void outputUnsignedLong(long n, IntConsumer consumer) {
        if (n >= 0L) {
            IntOutput.outputPositiveLong(n, consumer);
        } else {
            long m = (n >>> 1) / 50L;
            IntOutput.outputPositiveLong(m, consumer);
            int i = (int)(n - m * 100L);
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        }
    }

    public static void output2Digits(int i, IntConsumer consumer) {
        consumer.accept(tensDigits[i]);
        consumer.accept(digits[i]);
    }

    public static void output3Digits(int i, IntConsumer consumer) {
        int n = i / 100;
        consumer.accept(digits[n]);
        IntOutput.output2Digits(i - n * 100, consumer);
    }

    public static void outputIntGrouped(int i, char groupingChar, IntConsumer consumer) {
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                IntOutput.outputString(MIN_INTEGER_STRING, 0, 2, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_INTEGER_STRING, 2, 5, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_INTEGER_STRING, 5, 8, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_INTEGER_STRING, 8, 11, consumer);
            } else {
                consumer.accept(45);
                IntOutput.outputPositiveIntGrouped(-i, groupingChar, consumer);
            }
        } else {
            IntOutput.outputPositiveIntGrouped(i, groupingChar, consumer);
        }
    }

    public static void outputPositiveIntGrouped(int i, char groupingChar, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveIntGrouped1(n, groupingChar, consumer);
            consumer.accept(tensDigits[i -= n * 100]);
            consumer.accept(digits[i]);
        } else if (i >= 10) {
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        } else {
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveIntGrouped1(int i, char groupingChar, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveIntGrouped2(n, groupingChar, consumer);
            consumer.accept(tensDigits[i -= n * 100]);
            consumer.accept(groupingChar);
            consumer.accept(digits[i]);
        } else if (i >= 10) {
            consumer.accept(tensDigits[i]);
            consumer.accept(groupingChar);
            consumer.accept(digits[i]);
        } else {
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveIntGrouped2(int i, char groupingChar, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveIntGrouped(n, groupingChar, consumer);
            consumer.accept(groupingChar);
            consumer.accept(tensDigits[i -= n * 100]);
            consumer.accept(digits[i]);
        } else if (i >= 10) {
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        } else {
            consumer.accept(digits[i]);
        }
    }

    public static void outputLongGrouped(long n, char groupingChar, IntConsumer consumer) {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                IntOutput.outputString(MIN_LONG_STRING, 0, 2, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_STRING, 2, 5, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_STRING, 5, 8, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_STRING, 8, 11, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_STRING, 11, 14, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_STRING, 14, 17, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_STRING, 17, 20, consumer);
            } else {
                consumer.accept(45);
                IntOutput.outputPositiveLongGrouped(-n, groupingChar, consumer);
            }
        } else {
            IntOutput.outputPositiveLongGrouped(n, groupingChar, consumer);
        }
    }

    public static void outputPositiveLongGrouped(long n, char groupingChar, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLongGrouped1(m, groupingChar, consumer);
            int i = (int)(n - m * 100L);
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveLongGrouped1(long n, char groupingChar, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLongGrouped2(m, groupingChar, consumer);
            int i = (int)(n - m * 100L);
            consumer.accept(tensDigits[i]);
            consumer.accept(groupingChar);
            consumer.accept(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
                consumer.accept(groupingChar);
            }
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveLongGrouped2(long n, char groupingChar, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLongGrouped(m, groupingChar, consumer);
            int i = (int)(n - m * 100L);
            consumer.accept(groupingChar);
            consumer.accept(tensDigits[i]);
            consumer.accept(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    public static void outputIntHex(int i, IntConsumer consumer) {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.output16BitsHex(i >>> 16, consumer);
            IntOutput.output4Hex(i, consumer);
        } else {
            IntOutput.output16BitsHex(i, consumer);
        }
    }

    private static void output8BitsHex(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFFF0) != 0) {
            consumer.accept(digitsHex[i >>> 4]);
        }
        consumer.accept(digitsHex[i & 0xF]);
    }

    private static void output16BitsHex(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.output8BitsHex(i >>> 8, consumer);
            IntOutput.output2Hex(i, consumer);
        } else {
            IntOutput.output8BitsHex(i, consumer);
        }
    }

    public static void outputIntHexLC(int i, IntConsumer consumer) {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.output16BitsHexLC(i >>> 16, consumer);
            IntOutput.output4HexLC(i, consumer);
        } else {
            IntOutput.output16BitsHexLC(i, consumer);
        }
    }

    private static void output8BitsHexLC(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFFF0) != 0) {
            consumer.accept(digitsHexLC[i >>> 4]);
        }
        consumer.accept(digitsHexLC[i & 0xF]);
    }

    private static void output16BitsHexLC(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.output8BitsHexLC(i >>> 8, consumer);
            IntOutput.output2HexLC(i, consumer);
        } else {
            IntOutput.output8BitsHexLC(i, consumer);
        }
    }

    public static void outputLongHex(long n, IntConsumer consumer) {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.outputIntHex(hi, consumer);
            IntOutput.output8Hex(lo, consumer);
        } else {
            IntOutput.outputIntHex(lo, consumer);
        }
    }

    public static void outputLongHexLC(long n, IntConsumer consumer) {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.outputIntHexLC(hi, consumer);
            IntOutput.output8HexLC(lo, consumer);
        } else {
            IntOutput.outputIntHexLC(lo, consumer);
        }
    }

    public static void output8Hex(int i, IntConsumer consumer) {
        IntOutput.output4Hex(i >>> 16, consumer);
        IntOutput.output4Hex(i, consumer);
    }

    public static void output8HexLC(int i, IntConsumer consumer) {
        IntOutput.output4HexLC(i >>> 16, consumer);
        IntOutput.output4HexLC(i, consumer);
    }

    public static void output4Hex(int i, IntConsumer consumer) {
        IntOutput.output2Hex(i >> 8, consumer);
        IntOutput.output2Hex(i, consumer);
    }

    public static void output4HexLC(int i, IntConsumer consumer) {
        IntOutput.output2HexLC(i >> 8, consumer);
        IntOutput.output2HexLC(i, consumer);
    }

    public static void output2Hex(int i, IntConsumer consumer) {
        consumer.accept(digitsHex[i >> 4 & 0xF]);
        consumer.accept(digitsHex[i & 0xF]);
    }

    public static void output2HexLC(int i, IntConsumer consumer) {
        consumer.accept(digitsHexLC[i >> 4 & 0xF]);
        consumer.accept(digitsHexLC[i & 0xF]);
    }

    public static void output1Hex(int i, IntConsumer consumer) {
        consumer.accept(digitsHex[i & 0xF]);
    }

    public static void output1HexLC(int i, IntConsumer consumer) {
        consumer.accept(digitsHexLC[i & 0xF]);
    }

    private static void outputString(String s, int start, int end, IntConsumer consumer) {
        for (int i = start; i < end; ++i) {
            consumer.accept(s.charAt(i));
        }
    }

    private static void outputString(String s, IntConsumer consumer) {
        IntOutput.outputString(s, 0, s.length(), consumer);
    }
}

