/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.IOException;

public class Base64 {
    private static final byte[] base64Bytes;
    private static final byte[] base64URLBytes;
    private static final byte[] reverseBytes;
    private static final byte[] emptyBytes;

    private Base64() {
    }

    public static int getEncodedLength(int n) {
        return (n + 2) / 3 * 4;
    }

    public static int getEncodedURLLength(int n) {
        return (n * 4 + 2) / 3;
    }

    public static byte[] encode(byte[] data) {
        byte b;
        byte a;
        int n = data.length;
        if (n == 0) {
            return emptyBytes;
        }
        byte[] bytes = new byte[Base64.getEncodedLength(n)];
        int i = 0;
        int x = 0;
        int nm3 = n - 3;
        while (i <= nm3) {
            a = data[i++];
            b = data[i++];
            byte c = data[i++];
            bytes[x++] = base64Bytes[a >> 2 & 0x3F];
            bytes[x++] = base64Bytes[a << 4 & 0x30 | b >> 4 & 0xF];
            bytes[x++] = base64Bytes[b << 2 & 0x3C | c >> 6 & 3];
            bytes[x++] = base64Bytes[c & 0x3F];
        }
        if ((n -= i) > 0) {
            a = data[i];
            bytes[x++] = base64Bytes[a >> 2 & 0x3F];
            if (n == 1) {
                bytes[x++] = base64Bytes[a << 4 & 0x30];
                bytes[x++] = 61;
                bytes[x] = 61;
            } else {
                b = data[i + 1];
                bytes[x++] = base64Bytes[a << 4 & 0x30 | b >> 4 & 0xF];
                bytes[x++] = base64Bytes[b << 2 & 0x3C];
                bytes[x] = 61;
            }
        }
        return bytes;
    }

    public static byte[] encodeURL(byte[] data) {
        byte b;
        byte a;
        int n = data.length;
        if (n == 0) {
            return emptyBytes;
        }
        byte[] bytes = new byte[Base64.getEncodedURLLength(n)];
        int i = 0;
        int x = 0;
        int nm3 = n - 3;
        while (i <= nm3) {
            a = data[i++];
            b = data[i++];
            byte c = data[i++];
            bytes[x++] = base64URLBytes[a >> 2 & 0x3F];
            bytes[x++] = base64URLBytes[a << 4 & 0x30 | b >> 4 & 0xF];
            bytes[x++] = base64URLBytes[b << 2 & 0x3C | c >> 6 & 3];
            bytes[x++] = base64URLBytes[c & 0x3F];
        }
        if ((n -= i) > 0) {
            a = data[i];
            bytes[x++] = base64URLBytes[a >> 2 & 0x3F];
            if (n == 1) {
                bytes[x++] = base64URLBytes[a << 4 & 0x30];
            } else {
                b = data[i + 1];
                bytes[x++] = base64URLBytes[a << 4 & 0x30 | b >> 4 & 0xF];
                bytes[x++] = base64URLBytes[b << 2 & 0x3C];
            }
        }
        return bytes;
    }

    public static void appendEncoded(Appendable app, byte[] data) throws IOException {
        Base64.appendEncoded(app, data, 0, data.length);
    }

    public static void appendEncoded(Appendable app, byte[] data, int start, int end) throws IOException {
        byte b;
        byte a;
        int i = start;
        int endm3 = end - 3;
        while (i <= endm3) {
            a = data[i++];
            b = data[i++];
            byte c = data[i++];
            app.append((char)base64Bytes[a >> 2 & 0x3F]).append((char)base64Bytes[a << 4 & 0x30 | b >> 4 & 0xF]).append((char)base64Bytes[b << 2 & 0x3C | c >> 6 & 3]).append((char)base64Bytes[c & 0x3F]);
        }
        int n = end - i;
        if (n > 0) {
            a = data[i];
            app.append((char)base64Bytes[a >> 2 & 0x3F]);
            if (n == 1) {
                app.append((char)base64Bytes[a << 4 & 0x30]).append('=').append('=');
            } else {
                b = data[i + 1];
                app.append((char)base64Bytes[a << 4 & 0x30 | b >> 4 & 0xF]).append((char)base64Bytes[b << 2 & 0x3C]).append('=');
            }
        }
    }

    public static void appendURLEncoded(Appendable app, byte[] data) throws IOException {
        Base64.appendURLEncoded(app, data, 0, data.length);
    }

    public static void appendURLEncoded(Appendable app, byte[] data, int start, int end) throws IOException {
        byte b;
        byte a;
        int i = start;
        int endm3 = end - 3;
        while (i <= endm3) {
            a = data[i++];
            b = data[i++];
            byte c = data[i++];
            app.append((char)base64URLBytes[a >> 2 & 0x3F]).append((char)base64URLBytes[a << 4 & 0x30 | b >> 4 & 0xF]).append((char)base64URLBytes[b << 2 & 0x3C | c >> 6 & 3]).append((char)base64URLBytes[c & 0x3F]);
        }
        int n = end - i;
        if (n > 0) {
            a = data[i];
            app.append((char)base64URLBytes[a >> 2 & 0x3F]);
            if (n == 1) {
                app.append((char)base64URLBytes[a << 4 & 0x30]);
            } else {
                b = data[i + 1];
                app.append((char)base64URLBytes[a << 4 & 0x30 | b >> 4 & 0xF]).append((char)base64URLBytes[b << 2 & 0x3C]);
            }
        }
    }

    public String encodeString(byte[] data) {
        StringBuilder sb = new StringBuilder(Base64.getEncodedLength(data.length));
        try {
            Base64.appendEncoded(sb, data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public String encodeStringURL(byte[] data) {
        StringBuilder sb = new StringBuilder(Base64.getEncodedURLLength(data.length));
        try {
            Base64.appendURLEncoded(sb, data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static byte[] decode(byte[] data) {
        int c;
        int b;
        int a;
        int n = data.length;
        if (n == 0) {
            return emptyBytes;
        }
        if ((n & 3) == 0) {
            if (data[n - 1] == 61 && data[--n - 1] == 61) {
                --n;
            }
        } else if ((n & 3) == 1) {
            throw new IllegalArgumentException("Incorrect number of bytes for Base64");
        }
        byte[] bytes = new byte[n * 3 >> 2];
        int x = 0;
        int i = 0;
        int nm4 = n - 4;
        while (i <= nm4) {
            a = Base64.decodeByte(data[i++]);
            b = Base64.decodeByte(data[i++]);
            c = Base64.decodeByte(data[i++]);
            int d = Base64.decodeByte(data[i++]);
            bytes[x++] = (byte)(a << 2 & 0xFC | b >> 4 & 3);
            bytes[x++] = (byte)(b << 4 & 0xF0 | c >> 2 & 0xF);
            bytes[x++] = (byte)(c << 6 & 0xC0 | d);
        }
        if ((n -= i) > 0) {
            a = Base64.decodeByte(data[i]);
            b = Base64.decodeByte(data[i + 1]);
            bytes[x++] = (byte)(a << 2 & 0xFC | b >> 4 & 3);
            if (n == 2) {
                if ((b & 0xF) != 0) {
                    throw new IllegalArgumentException("Illegal character in Base64");
                }
            } else {
                c = Base64.decodeByte(data[i + 2]);
                bytes[x++] = (byte)(b << 4 & 0xF0 | c >> 2 & 0xF);
                if ((c & 3) != 0) {
                    throw new IllegalArgumentException("Illegal character in Base64");
                }
            }
        }
        return bytes;
    }

    public static byte[] decode(CharSequence data) {
        int c;
        int b;
        int a;
        int n = data.length();
        if (n == 0) {
            return emptyBytes;
        }
        if ((n & 3) == 0) {
            if (data.charAt(n - 1) == '=' && data.charAt(--n - 1) == '=') {
                --n;
            }
        } else if ((n & 3) == 1) {
            throw new IllegalArgumentException("Incorrect number of bytes for Base64");
        }
        byte[] bytes = new byte[n * 3 >> 2];
        int x = 0;
        int i = 0;
        int nm4 = n - 4;
        while (i <= nm4) {
            a = Base64.decodeByte(data.charAt(i++));
            b = Base64.decodeByte(data.charAt(i++));
            c = Base64.decodeByte(data.charAt(i++));
            int d = Base64.decodeByte(data.charAt(i++));
            bytes[x++] = (byte)(a << 2 & 0xFC | b >> 4 & 3);
            bytes[x++] = (byte)(b << 4 & 0xF0 | c >> 2 & 0xF);
            bytes[x++] = (byte)(c << 6 & 0xC0 | d);
        }
        if ((n -= i) > 0) {
            a = Base64.decodeByte(data.charAt(i));
            b = Base64.decodeByte(data.charAt(i + 1));
            bytes[x++] = (byte)(a << 2 & 0xFC | b >> 4 & 3);
            if (n == 2) {
                if ((b & 0xF) != 0) {
                    throw new IllegalArgumentException("Illegal character in Base64");
                }
            } else {
                c = Base64.decodeByte(data.charAt(i + 2));
                bytes[x++] = (byte)(b << 4 & 0xF0 | c >> 2 & 0xF);
                if ((c & 3) != 0) {
                    throw new IllegalArgumentException("Illegal character in Base64");
                }
            }
        }
        return bytes;
    }

    private static int decodeByte(int b) {
        byte result;
        if ((b & 0xFFFFFF80) == 0 && ((result = reverseBytes[b]) & 0xFFFFFFC0) == 0) {
            return result;
        }
        throw new IllegalArgumentException("Illegal character in Base64");
    }

    static {
        int i;
        base64Bytes = new byte[64];
        base64URLBytes = new byte[64];
        reverseBytes = new byte[128];
        emptyBytes = new byte[0];
        for (i = 0; i < 128; ++i) {
            Base64.reverseBytes[i] = -1;
        }
        for (i = 0; i < 26; ++i) {
            Base64.base64Bytes[i] = (byte)(65 + i);
            Base64.base64URLBytes[i] = (byte)(65 + i);
            Base64.reverseBytes[65 + i] = (byte)i;
        }
        for (i = 0; i < 26; ++i) {
            Base64.base64Bytes[i + 26] = (byte)(97 + i);
            Base64.base64URLBytes[i + 26] = (byte)(97 + i);
            Base64.reverseBytes[97 + i] = (byte)(i + 26);
        }
        for (i = 0; i < 10; ++i) {
            Base64.base64Bytes[i + 52] = (byte)(48 + i);
            Base64.base64URLBytes[i + 52] = (byte)(48 + i);
            Base64.reverseBytes[48 + i] = (byte)(i + 52);
        }
        Base64.base64Bytes[62] = 43;
        Base64.reverseBytes[43] = 62;
        Base64.base64URLBytes[62] = 45;
        Base64.reverseBytes[45] = 62;
        Base64.base64Bytes[63] = 47;
        Base64.reverseBytes[47] = 63;
        Base64.base64URLBytes[63] = 95;
        Base64.reverseBytes[95] = 63;
    }
}

