/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class ListMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -5594713182082941289L;
    protected List<Entry<K, V>> list;

    public ListMap() {
        this.list = new ArrayList<Entry<K, V>>();
    }

    public ListMap(int capacity) {
        this.list = new ArrayList<Entry<K, V>>(capacity);
    }

    public ListMap(Map<? extends K, ? extends V> m) {
        this(m.size());
        this.putAll(m);
    }

    @Override
    public V get(Object key) {
        int index = this.findIndex(Objects.requireNonNull(key));
        return index < 0 ? null : (V)this.list.get(index).getValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findIndex(Objects.requireNonNull(key)) >= 0;
    }

    @Override
    public V put(K key, V value) {
        int index = this.findIndex(Objects.requireNonNull(key));
        if (index >= 0) {
            Entry<K, V> entry = this.list.get(index);
            V oldValue = entry.getValue();
            entry.setValue(value);
            return oldValue;
        }
        this.list.add(new Entry<K, V>(key, value));
        return null;
    }

    @Override
    public V remove(Object key) {
        int index = this.findIndex(Objects.requireNonNull(key));
        if (index >= 0) {
            return this.list.remove(index).getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(this.list.get(i).getValue(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public int hashCode() {
        int result = 0;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            result ^= this.list.get(i).hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ListMap)) {
            return false;
        }
        ListMap otherMapping = (ListMap)other;
        if (this.list.size() != otherMapping.list.size()) {
            return false;
        }
        for (Entry<K, V> entry : this.list) {
            if (Objects.equals(entry.getValue(), otherMapping.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int n = this.list.size();
        if (n > 0) {
            int i = 0;
            while (true) {
                Entry<K, V> e;
                if (((Entry)(e = this.list.get(i++))).value == this) {
                    sb.append(((Entry)e).key).append('=').append("(this Map)");
                } else {
                    sb.append(e);
                }
                if (i >= n) break;
                sb.append(',').append(' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public Entry<K, V> getEntry(int index) {
        return this.list.get(index);
    }

    protected int findIndex(Object key) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (!this.list.get(i).getKey().equals(key)) continue;
            return i;
        }
        return -1;
    }

    private abstract class CollectionBase<T>
    extends AbstractSet<T> {
        private CollectionBase() {
        }

        @Override
        public int size() {
            return ListMap.this.list.size();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueCollection
    extends CollectionBase<V> {
        private ValueCollection() {
        }

        @Override
        public boolean contains(Object o) {
            return ListMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (ListMap.this.containsValue(o)) continue;
                return false;
            }
            return true;
        }
    }

    private class KeySet
    extends CollectionBase<K> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return ListMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (ListMap.this.containsKey(o)) continue;
                return false;
            }
            return true;
        }
    }

    private class EntrySet
    extends CollectionBase<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            return ListMap.this.list.contains(o);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (ListMap.this.list.contains(o)) continue;
                return false;
            }
            return true;
        }
    }

    private abstract class BaseIterator<T>
    implements Iterator<T> {
        private int index = 0;

        public Entry<K, V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ListMap.this.list.get(this.index++);
        }

        @Override
        public boolean hasNext() {
            return this.index < ListMap.this.list.size();
        }
    }

    private class ValueIterator
    extends BaseIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends BaseIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends BaseIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    public static class Entry<KK, VV>
    implements Map.Entry<KK, VV>,
    Serializable {
        private static final long serialVersionUID = -7610378954393786210L;
        private final KK key;
        private VV value;

        public Entry(KK key, VV value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public KK getKey() {
            return this.key;
        }

        @Override
        public VV getValue() {
            return this.value;
        }

        @Override
        public VV setValue(VV value) {
            VV oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry otherEntry = (Map.Entry)other;
            return Objects.equals(this.key, otherEntry.getKey()) && Objects.equals(this.value, otherEntry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }
    }
}

