/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class OrderedSet<E>
extends AbstractSet<E> {
    private List<E> list = new ArrayList();
    private Comparator<E> comparator;

    public OrderedSet(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public OrderedSet(Comparator<E> comparator, Collection<? extends E> c) {
        this(comparator);
        this.addAll(c);
    }

    @Override
    public boolean contains(Object o) {
        Object c = Objects.requireNonNull(o);
        int lo = 0;
        int hi = this.list.size();
        while (lo < hi) {
            int mid = lo + hi >> 1;
            int comp = this.comparator.compare(this.list.get(mid), c);
            if (comp == 0) {
                return true;
            }
            if (comp < 0) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        Objects.requireNonNull(e);
        int lo = 0;
        int hi = this.list.size();
        while (lo < hi) {
            int mid = lo + hi >> 1;
            int comp = this.comparator.compare(this.list.get(mid), e);
            if (comp == 0) {
                return false;
            }
            if (comp < 0) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        this.list.add(lo, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Object c = Objects.requireNonNull(o);
        int lo = 0;
        int hi = this.list.size();
        while (lo < hi) {
            int mid = lo + hi >> 1;
            int comp = this.comparator.compare(this.list.get(mid), c);
            if (comp == 0) {
                this.list.remove(mid);
                return true;
            }
            if (comp < 0) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return false;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public static <C extends Comparable<C>> OrderedSet<C> create() {
        return new OrderedSet(new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public class Iter
    implements Iterator<E> {
        private int index = 0;
        private boolean removeAllowed = false;

        @Override
        public boolean hasNext() {
            return this.index < OrderedSet.this.list.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeAllowed = true;
            return OrderedSet.this.list.get(this.index++);
        }

        @Override
        public void remove() {
            if (!this.removeAllowed) {
                throw new IllegalStateException();
            }
            this.removeAllowed = false;
            OrderedSet.this.list.remove(--this.index);
        }
    }
}

