/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.pwall.util.SubSequence;

public class ReaderBuffer
implements CharSequence {
    public static final int defaultBufferSize = 4096;
    private int bufferSize;
    private char[][] buffers;
    private int length;
    private String str;

    public ReaderBuffer(Reader rdr, int bufferSize) throws IOException {
        int len;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        this.bufferSize = bufferSize;
        this.str = null;
        this.length = 0;
        ArrayList<char[]> bufferList = new ArrayList<char[]>();
        do {
            int n;
            char[] buffer = new char[bufferSize];
            len = bufferSize;
            int offset = 0;
            while ((n = rdr.read(buffer, offset, len)) >= 0) {
                offset += n;
                if ((len -= n) > 0) continue;
            }
            if (offset == 0) break;
            bufferList.add(buffer);
            this.length += bufferSize - len;
        } while (len <= 0);
        this.buffers = (char[][])bufferList.toArray((T[])new char[bufferList.size()][]);
    }

    public ReaderBuffer(Reader rdr) throws IOException {
        this(rdr, 4096);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.buffers[index / this.bufferSize][index % this.bufferSize];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SubSequence(this, start, end);
    }

    @Override
    public String toString() {
        if (this.str == null) {
            StringBuilder sb = new StringBuilder(this.length);
            int lastbuffer = this.buffers.length - 1;
            for (int i = 0; i < lastbuffer; ++i) {
                sb.append(this.buffers[i]);
            }
            if (lastbuffer >= 0) {
                sb.append(this.buffers[lastbuffer], 0, this.length - lastbuffer * this.bufferSize);
            }
            this.str = sb.toString();
        }
        return this.str;
    }

    public static String toString(Reader rdr) throws IOException {
        return new ReaderBuffer(rdr).toString();
    }

    public static String toString(Reader rdr, int bufferSize) throws IOException {
        return new ReaderBuffer(rdr, bufferSize).toString();
    }
}

