/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.IntPredicate;
import net.pwall.util.ByteArrayBuilder;
import net.pwall.util.CharMapper;
import net.pwall.util.CharUnmapper;
import net.pwall.util.SubSequence;

public class Strings {
    private static final String[] numberNamesEnglish = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] tensNamesEnglish = new String[]{"twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String emptyString = "";
    private static final String[] emptyStringArray = new String[0];
    private static final int MAX_INT_DIV_10 = 0xCCCCCCC;
    private static final int MAX_INT_MOD_10 = 7;
    private static final long MAX_LONG_DIV_10 = 0xCCCCCCCCCCCCCCCL;
    private static final int MAX_LONG_MOD_10 = 7;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static char[] tensDigits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};

    private Strings() throws IllegalAccessException {
        throw new IllegalAccessException("Attempt to instantiate Strings class");
    }

    public static String toEnglish(int n) {
        if (n >= 0 && n < 20) {
            return numberNamesEnglish[n];
        }
        StringBuilder sb = new StringBuilder();
        try {
            Strings.appendEnglish(sb, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static Appendable appendEnglish(Appendable a, int n) throws IOException {
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            if (n >= 0 && n < 20) {
                                return a.append(numberNamesEnglish[n]);
                            }
                            if (n < 0) {
                                a.append("minus ");
                                if (n == Integer.MIN_VALUE) {
                                    a.append("two billion, ");
                                    n = 147483648;
                                } else {
                                    n = -n;
                                }
                            }
                            if (n < 1000000000) break block10;
                            Strings.appendEnglish(a, n / 1000000000).append(" billion");
                            if ((n %= 1000000000) == 0) break block11;
                            a.append(n >= 100 ? ", " : " and ");
                        }
                        if (n < 1000000) break block12;
                        Strings.appendEnglish(a, n / 1000000).append(" million");
                        if ((n %= 1000000) == 0) break block11;
                        a.append(n >= 100 ? ", " : " and ");
                    }
                    if (n < 1000) break block13;
                    Strings.appendEnglish(a, n / 1000).append(" thousand");
                    if ((n %= 1000) == 0) break block11;
                    a.append(n >= 100 ? ", " : " and ");
                }
                if (n < 100) break block14;
                a.append(numberNamesEnglish[n / 100]).append(" hundred");
                if ((n %= 100) == 0) break block11;
                a.append(" and ");
            }
            if (n >= 20) {
                a.append(tensNamesEnglish[n / 10 - 2]);
                if ((n %= 10) != 0) {
                    a.append('-');
                }
            }
            if (n > 0) {
                a.append(numberNamesEnglish[n]);
            }
        }
        return a;
    }

    public static String capitalise(String str) {
        char ch;
        int n = str.length();
        if (n > 0 && Character.isLowerCase(ch = str.charAt(0))) {
            StringBuilder sb = new StringBuilder(n);
            sb.append(Character.toUpperCase(ch));
            if (n > 1) {
                sb.append(str, 1, n);
            }
            return sb.toString();
        }
        return str;
    }

    public static String plural(String noun, int n) {
        StringBuilder sb = new StringBuilder();
        sb.append(n).append(' ').append(noun);
        if (n != 1) {
            sb.append('s');
        }
        return sb.toString();
    }

    public static String plural(String singularNoun, String pluralNoun, int n) {
        StringBuilder sb = new StringBuilder();
        sb.append(n).append(' ').append(n == 1 ? singularNoun : pluralNoun);
        return sb.toString();
    }

    public static String[] split(String s) {
        return Strings.split(s, 0, s.length(), Character::isWhitespace);
    }

    public static String[] split(String s, int start, int end) {
        return Strings.split(s, start, end, Character::isWhitespace);
    }

    public static String[] split(String s, IntPredicate spaceTest) {
        return Strings.split(s, 0, s.length(), spaceTest);
    }

    public static String[] split(String s, int start, int end, IntPredicate spaceTest) {
        while (true) {
            if (start >= end) {
                return emptyStringArray;
            }
            if (!spaceTest.test(s.charAt(start))) break;
            ++start;
        }
        while (spaceTest.test(s.charAt(--end))) {
        }
        int count = 0;
        int i = start + 1;
        while (i < end) {
            if (!spaceTest.test(s.charAt(i++))) continue;
            ++count;
            while (spaceTest.test(s.charAt(i++))) {
            }
        }
        String[] result = new String[count + 1];
        i = start;
        for (int j = 0; j < count; ++j) {
            int k = i;
            while (!spaceTest.test(s.charAt(++i))) {
            }
            result[j] = s.substring(k, i);
            while (spaceTest.test(s.charAt(++i))) {
            }
        }
        result[count] = s.substring(i, end + 1);
        return result;
    }

    public static String[] split(String s1, String s2) {
        int count = 0;
        int i = 0;
        int n2 = s2.length();
        int stopper = s1.length() - n2;
        while (i <= stopper) {
            if (s1.regionMatches(i, s2, 0, n2)) {
                ++count;
                i += n2;
                continue;
            }
            ++i;
        }
        String[] result = new String[count + 1];
        i = 0;
        for (int j = 0; j < count; ++j) {
            int k = i;
            while (!s1.regionMatches(i, s2, 0, n2)) {
                ++i;
            }
            result[j] = s1.substring(k, i);
            i += n2;
        }
        result[count] = s1.substring(i);
        return result;
    }

    public static String[] split(String s, char separator) {
        return Strings.split(s, 0, s.length(), separator, true, Character::isWhitespace);
    }

    public static String[] split(String s, char separator, boolean skipEmpty, IntPredicate spaceTest) {
        return Strings.split(s, 0, s.length(), separator, skipEmpty, spaceTest);
    }

    public static String[] split(String s, int start, int end, char separator, boolean skipEmpty, IntPredicate spaceTest) {
        int count = 0;
        int i = start;
        if (skipEmpty) {
            if (spaceTest != null) {
                while (true) {
                    char ch;
                    boolean nonSpaceSeen = false;
                    while (i < end && (ch = s.charAt(i)) != separator) {
                        nonSpaceSeen = nonSpaceSeen || !spaceTest.test(ch);
                        ++i;
                    }
                    if (nonSpaceSeen) {
                        ++count;
                    }
                    if (i < end) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    int itemStart = ++i;
                    while (i < end && s.charAt(i) != separator) {
                        ++i;
                    }
                    if (i > itemStart) {
                        ++count;
                    }
                    if (i >= end) break;
                }
            }
            if (count == 0) {
                return emptyStringArray;
            }
        } else {
            count = 1;
            while (i < end) {
                if (s.charAt(i++) != separator) continue;
                ++count;
            }
        }
        String[] result = new String[count];
        i = start;
        int j = 0;
        while (true) {
            int itemStart = ++i;
            while (i < end && s.charAt(i) != separator) {
                ++i;
            }
            int itemEnd = i;
            if (spaceTest != null) {
                while (itemStart < itemEnd && spaceTest.test(s.charAt(itemStart))) {
                    ++itemStart;
                }
                while (itemStart < itemEnd && spaceTest.test(s.charAt(itemEnd - 1))) {
                    --itemEnd;
                }
            }
            if (itemEnd > itemStart) {
                result[j++] = s.substring(itemStart, itemEnd);
            } else if (!skipEmpty) {
                result[j++] = emptyString;
            }
            if (i >= end) break;
        }
        return result;
    }

    public static <E> String join(Iterable<E> collection) {
        return Strings.join(collection.iterator());
    }

    public static <E> String join(Iterator<E> it) {
        if (!it.hasNext()) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(it.next());
        } while (it.hasNext());
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(Enumeration<E> e) {
        if (!e.hasMoreElements()) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(e.nextElement());
        } while (e.hasMoreElements());
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(E[] array) {
        int n = array.length;
        if (n == 0) {
            return emptyString;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(array[i++]);
        } while (i < n);
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(Iterable<E> collection, char separator) {
        return Strings.join(collection.iterator(), separator);
    }

    public static <E> String join(Iterator<E> it, char separator) {
        if (!it.hasNext()) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(it.next());
            if (!it.hasNext()) break;
            sb.append(separator);
        }
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(Enumeration<E> e, char separator) {
        if (!e.hasMoreElements()) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(e.nextElement());
            if (!e.hasMoreElements()) break;
            sb.append(separator);
        }
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(E[] array, char separator) {
        int n = array.length;
        if (n == 0) {
            return emptyString;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(array[i++]);
            if (i >= n) break;
            sb.append(separator);
        }
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(Iterable<E> collection, String separator) {
        return Strings.join(collection.iterator(), separator);
    }

    public static <E> String join(Iterator<E> it, String separator) {
        if (!it.hasNext()) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(it.next());
            if (!it.hasNext()) break;
            sb.append(separator);
        }
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(Enumeration<E> e, String separator) {
        if (!e.hasMoreElements()) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(e.nextElement());
            if (!e.hasMoreElements()) break;
            sb.append(separator);
        }
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static <E> String join(E[] array, String separator) {
        int n = array.length;
        if (n == 0) {
            return emptyString;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(array[i++]);
            if (i >= n) break;
            sb.append(separator);
        }
        return sb.length() == 0 ? emptyString : sb.toString();
    }

    public static String escape(String s, CharMapper mapper) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            String mapped;
            if ((mapped = mapper.map(s.charAt(i++))) == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(s, 0, i - 1);
            sb.append(mapped);
            try {
                Strings.appendEscaped(sb, s, i, n, mapper);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sb.toString();
        }
        return s;
    }

    public static CharSequence escape(CharSequence s, CharMapper mapper) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            String mapped;
            if ((mapped = mapper.map(s.charAt(i++))) == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(s, 0, i - 1);
            sb.append(mapped);
            try {
                Strings.appendEscaped(sb, s, i, n, mapper);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sb;
        }
        return s;
    }

    public static void appendEscaped(Appendable a, CharSequence s, int index, int end, CharMapper mapper) throws IOException {
        while (index < end) {
            char ch;
            String mapped;
            if ((mapped = mapper.map(ch = s.charAt(index++))) != null) {
                a.append(mapped);
                continue;
            }
            a.append(ch);
        }
    }

    public static void appendEscaped(Appendable a, CharSequence s, CharMapper mapper) throws IOException {
        Strings.appendEscaped(a, s, 0, s.length(), mapper);
    }

    public static String escapeUTF16(String s, CharMapper mapper) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            String mapped;
            char ch1;
            int k = i;
            if (Character.isHighSurrogate(ch1 = s.charAt(i++))) {
                char ch2;
                if (i >= n || !Character.isLowSurrogate(ch2 = s.charAt(i++))) {
                    throw new IllegalArgumentException("Illegal surrogate sequence");
                }
                mapped = mapper.map(Character.toCodePoint(ch1, ch2));
            } else {
                mapped = mapper.map(ch1);
            }
            if (mapped == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(s, 0, k);
            sb.append(mapped);
            try {
                Strings.appendEscapedUTF16(sb, s, i, n, mapper);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sb.toString();
        }
        return s;
    }

    public static CharSequence escapeUTF16(CharSequence s, CharMapper mapper) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            String mapped;
            char ch1;
            int k = i;
            if (Character.isHighSurrogate(ch1 = s.charAt(i++))) {
                char ch2;
                if (i >= n || !Character.isLowSurrogate(ch2 = s.charAt(i++))) {
                    throw new IllegalArgumentException("Illegal surrogate sequence");
                }
                mapped = mapper.map(Character.toCodePoint(ch1, ch2));
            } else {
                mapped = mapper.map(ch1);
            }
            if (mapped == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(s, 0, k);
            sb.append(mapped);
            try {
                Strings.appendEscapedUTF16(sb, s, i, n, mapper);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sb;
        }
        return s;
    }

    public static void appendEscapedUTF16(Appendable a, CharSequence s, int index, int end, CharMapper mapper) throws IOException {
        while (index < end) {
            String mapped;
            char ch1;
            if (Character.isHighSurrogate(ch1 = s.charAt(index++))) {
                char ch2;
                if (index >= end || !Character.isLowSurrogate(ch2 = s.charAt(index++))) {
                    throw new IllegalArgumentException("Illegal surrogate sequence");
                }
                mapped = mapper.map(Character.toCodePoint(ch1, ch2));
                if (mapped != null) {
                    a.append(mapped);
                    continue;
                }
                a.append(ch1).append(ch2);
                continue;
            }
            mapped = mapper.map(ch1);
            if (mapped != null) {
                a.append(mapped);
                continue;
            }
            a.append(ch1);
        }
    }

    public static void appendEscapedUTF16(Appendable a, CharSequence s, CharMapper mapper) throws IOException {
        Strings.appendEscapedUTF16(a, s, 0, s.length(), mapper);
    }

    public static String unescape(String s, CharUnmapper unmapper) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (!unmapper.isEscape(s, i)) continue;
            StringBuilder sb = new StringBuilder(s.length());
            sb.append(s, 0, i);
            i += unmapper.unmap(sb, s, i);
            while (i < n) {
                if (unmapper.isEscape(s, i)) {
                    i += unmapper.unmap(sb, s, i);
                    continue;
                }
                sb.append(s.charAt(i++));
            }
            return sb.toString();
        }
        return s;
    }

    public static CharSequence unescape(CharSequence s, CharUnmapper unmapper) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (!unmapper.isEscape(s, i)) continue;
            StringBuilder sb = new StringBuilder(s.length());
            sb.append(s, 0, i);
            i += unmapper.unmap(sb, s, i);
            while (i < n) {
                if (unmapper.isEscape(s, i)) {
                    i += unmapper.unmap(sb, s, i);
                    continue;
                }
                sb.append(s.charAt(i++));
            }
            return sb;
        }
        return s;
    }

    public static String toUTF16(int codePoint) {
        StringBuilder sb = new StringBuilder(2);
        try {
            Strings.appendUTF16(sb, codePoint);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String toUTF16(int[] codePoints) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < codePoints.length; ++i) {
            try {
                Strings.appendUTF16(sb, codePoints[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void appendUTF16(Appendable a, int codePoint) throws IOException {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            a.append(Character.highSurrogate(codePoint));
            a.append(Character.lowSurrogate(codePoint));
        } else if (Character.isBmpCodePoint(codePoint) && !Character.isSurrogate((char)codePoint)) {
            a.append((char)codePoint);
        } else {
            throw new IllegalArgumentException("Illegal character for UTF-16");
        }
    }

    public static byte[] toUTF8(String str) {
        if (str == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        return Strings.toUTF8(str, 0, str.length());
    }

    public static String fromUTF8(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array must not be null");
        }
        return Strings.fromUTF8(bytes, 0, bytes.length);
    }

    public static byte[] toUTF8(String str, int start, int end) {
        if (str == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        ByteArrayBuilder bab = new ByteArrayBuilder((end - start) * 5 / 4);
        for (int i = start; i < end; ++i) {
            int codePoint;
            int ch = str.charAt(i);
            if (Character.isHighSurrogate((char)ch)) {
                char lowSurrogate;
                if (++i >= end || !Character.isLowSurrogate(lowSurrogate = str.charAt(i))) {
                    throw new IllegalArgumentException("Invalid UTF-16 surrogate sequence");
                }
                codePoint = Character.toCodePoint((char)ch, lowSurrogate);
            } else {
                codePoint = ch;
            }
            Strings.appendUTF8(bab, codePoint);
        }
        return bab.toByteArray();
    }

    public static void appendUTF8(ByteArrayBuilder bab, int codepoint) {
        if (codepoint <= 127) {
            bab.append(codepoint);
        } else if (codepoint <= 2047) {
            bab.append(codepoint >> 6 | 0xC0);
            bab.append(codepoint & 0x3F | 0x80);
        } else if (codepoint <= 65535) {
            bab.append(codepoint >> 12 | 0xE0);
            bab.append(codepoint >> 6 & 0x3F | 0x80);
            bab.append(codepoint & 0x3F | 0x80);
        } else {
            bab.append(codepoint >> 18 & 7 | 0xF0);
            bab.append(codepoint >> 12 & 0x3F | 0x80);
            bab.append(codepoint >> 6 & 0x3F | 0x80);
            bab.append(codepoint & 0x3F | 0x80);
        }
    }

    public static String fromUTF8(final ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("ByteBuffer must not be null");
        }
        return Strings.fromUTF8(new Iterator<Byte>(){

            @Override
            public boolean hasNext() {
                return byteBuffer.hasRemaining();
            }

            @Override
            public Byte next() {
                return byteBuffer.get();
            }
        });
    }

    public static String fromUTF8(final ByteBuffer[] byteBuffers) {
        if (byteBuffers == null) {
            throw new IllegalArgumentException("ByteBuffer array must not be null");
        }
        return Strings.fromUTF8(new Iterator<Byte>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                while (this.i < byteBuffers.length) {
                    if (byteBuffers[this.i].hasRemaining()) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            @Override
            public Byte next() {
                return byteBuffers[this.i].get();
            }
        });
    }

    public static String fromUTF8(Iterator<Byte> byteIterator) {
        if (byteIterator == null) {
            throw new IllegalArgumentException("Byte iterator must not be null");
        }
        StringBuilder sb = new StringBuilder();
        while (byteIterator.hasNext()) {
            int codePoint;
            byte b = byteIterator.next();
            if ((b & 0x80) == 0) {
                sb.append((char)b);
                continue;
            }
            if ((b & 0x40) == 0) {
                throw new IllegalArgumentException("Illegal character in UTF-8 bytes");
            }
            if ((b & 0x20) == 0) {
                codePoint = b & 0x1F;
                codePoint = Strings.addToCodePoint(codePoint, byteIterator);
                sb.append((char)codePoint);
                continue;
            }
            if ((b & 0x10) == 0) {
                codePoint = b & 0xF;
                codePoint = Strings.addToCodePoint(codePoint, byteIterator);
                codePoint = Strings.addToCodePoint(codePoint, byteIterator);
                sb.append((char)codePoint);
                continue;
            }
            codePoint = b & 7;
            codePoint = Strings.addToCodePoint(codePoint, byteIterator);
            codePoint = Strings.addToCodePoint(codePoint, byteIterator);
            codePoint = Strings.addToCodePoint(codePoint, byteIterator);
            try {
                Strings.appendUTF16(sb, codePoint);
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    private static int addToCodePoint(int codePoint, Iterator<Byte> byteIterator) {
        if (!byteIterator.hasNext()) {
            throw new IllegalArgumentException("Incomplete sequence in UTF-8 bytes");
        }
        byte b = byteIterator.next();
        if ((b & 0xC0) != 128) {
            throw new IllegalArgumentException("Illegal character in UTF-8 bytes");
        }
        return codePoint << 6 | b & 0x3F;
    }

    public static String fromUTF8(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("Byte array must not be null");
        }
        if (start < 0 || start > bytes.length) {
            throw new IllegalArgumentException("Start index invalid: " + start);
        }
        if (end < start || end > bytes.length) {
            throw new IllegalArgumentException("End index invalid: " + end);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            int codePoint;
            byte b = bytes[i];
            if ((b & 0x80) == 0) {
                sb.append((char)b);
                continue;
            }
            if ((b & 0x40) == 0) {
                throw new IllegalArgumentException("Illegal character in UTF-8 bytes");
            }
            if ((b & 0x20) == 0) {
                codePoint = b & 0x1F;
                codePoint = Strings.addToCodePoint(codePoint, bytes, ++i, end);
                sb.append((char)codePoint);
                continue;
            }
            if ((b & 0x10) == 0) {
                codePoint = b & 0xF;
                codePoint = Strings.addToCodePoint(codePoint, bytes, ++i, end);
                codePoint = Strings.addToCodePoint(codePoint, bytes, ++i, end);
                sb.append((char)codePoint);
                continue;
            }
            codePoint = b & 7;
            codePoint = Strings.addToCodePoint(codePoint, bytes, ++i, end);
            codePoint = Strings.addToCodePoint(codePoint, bytes, ++i, end);
            codePoint = Strings.addToCodePoint(codePoint, bytes, ++i, end);
            try {
                Strings.appendUTF16(sb, codePoint);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private static int addToCodePoint(int codePoint, byte[] bytes, int index, int end) {
        if (index >= end) {
            throw new IllegalArgumentException("Incomplete sequence in UTF-8 bytes");
        }
        byte b = bytes[index];
        if ((b & 0xC0) != 128) {
            throw new IllegalArgumentException("Illegal character in UTF-8 bytes");
        }
        return codePoint << 6 | b & 0x3F;
    }

    public static String toHex(CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        int n = s.length();
        if (n == 0) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            try {
                Strings.appendHex((Appendable)sb, s.charAt(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static String toHex(CharSequence s, char separator) {
        if (s == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        int n = s.length();
        if (n == 0) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            try {
                Strings.appendHex((Appendable)sb, s.charAt(i++));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (i >= n) break;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        int n = bytes.length;
        if (n == 0) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            try {
                Strings.appendHex((Appendable)sb, bytes[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static String toHex(byte[] bytes, char separator) {
        if (bytes == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        int n = bytes.length;
        if (n == 0) {
            return emptyString;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            try {
                Strings.appendHex((Appendable)sb, bytes[i++]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (i >= n) break;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String toHex(byte b) {
        StringBuilder sb = new StringBuilder(2);
        try {
            Strings.appendHex((Appendable)sb, b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String toHex(char ch) {
        StringBuilder sb = new StringBuilder(4);
        try {
            Strings.appendHex((Appendable)sb, ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String toHex(int i) {
        StringBuilder sb = new StringBuilder(8);
        try {
            Strings.appendHex((Appendable)sb, i);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String toHex(long n) {
        StringBuilder sb = new StringBuilder(16);
        try {
            Strings.appendHex((Appendable)sb, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void appendHex(Appendable a, byte b) throws IOException {
        a.append(hexDigits[b >>> 4 & 0xF]);
        a.append(hexDigits[b & 0xF]);
    }

    public static void appendHex(Appendable a, char ch) throws IOException {
        Strings.appendHex(a, (byte)(ch >>> 8));
        Strings.appendHex(a, (byte)ch);
    }

    public static void appendHex(Appendable a, int i) throws IOException {
        Strings.appendHex(a, (char)(i >>> 16));
        Strings.appendHex(a, (char)i);
    }

    public static void appendHex(Appendable a, int i, int digits) throws IOException {
        if (digits > 0) {
            Strings.appendHex(a, i >>> 4, digits - 1);
            a.append(hexDigits[i & 0xF]);
        }
    }

    public static void appendHex(Appendable a, long n) throws IOException {
        Strings.appendHex(a, (int)(n >>> 32));
        Strings.appendHex(a, (int)n);
    }

    public static void appendHex(Appendable a, long n, int digits) throws IOException {
        if (digits > 0) {
            Strings.appendHex(a, n >>> 4, digits - 1);
            a.append(hexDigits[(int)(n & 0xFL)]);
        }
    }

    public static int convertToInt(CharSequence text, int start, int end) {
        if (start < 0 || end > text.length() || start >= end) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = start; i < end; ++i) {
            int n = Strings.convertDecDigit(text.charAt(i));
            if (result > 0xCCCCCCC || result == 0xCCCCCCC && n > 7) {
                throw new NumberFormatException();
            }
            result = result * 10 + n;
        }
        return result;
    }

    public static long convertToLong(CharSequence text, int start, int end) {
        if (start < 0 || end > text.length() || start >= end) {
            throw new IndexOutOfBoundsException();
        }
        long result = 0L;
        for (int i = start; i < end; ++i) {
            int n = Strings.convertDecDigit(text.charAt(i));
            if (result > 0xCCCCCCCCCCCCCCCL || result == 0xCCCCCCCCCCCCCCCL && n > 7) {
                throw new NumberFormatException();
            }
            result = result * 10L + (long)n;
        }
        return result;
    }

    public static int convertDecDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new NumberFormatException();
    }

    public static int convertHexToInt(CharSequence text, int start, int end) {
        if (start < 0 || end > text.length() || start >= end) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = start; i < end; ++i) {
            if ((result & 0xF8000000) != 0) {
                throw new NumberFormatException();
            }
            result = result << 4 | Strings.convertHexDigit(text.charAt(i));
        }
        return result;
    }

    public static long convertHexToLong(CharSequence text, int start, int end) {
        if (start < 0 || end > text.length() || start >= end) {
            throw new IndexOutOfBoundsException();
        }
        long result = 0L;
        for (int i = start; i < end; ++i) {
            if ((result & 0xF800000000000000L) != 0L) {
                throw new NumberFormatException();
            }
            result = result << 4 | (long)Strings.convertHexDigit(text.charAt(i));
        }
        return result;
    }

    public static int convertHexDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new NumberFormatException();
    }

    public static boolean multiWildcardCompare(String pattern, CharSequence target) {
        int i;
        int patIndex = 0;
        while ((i = pattern.indexOf(124, patIndex)) >= 0) {
            if (Strings.wildcardCompare(pattern, patIndex, i, target)) {
                return true;
            }
            patIndex = i + 1;
        }
        return Strings.wildcardCompare(pattern, patIndex, pattern.length(), target);
    }

    public static boolean wildcardCompare(String pattern, CharSequence target) {
        return Strings.wildcardCompare(pattern, 0, pattern.length(), target);
    }

    public static boolean wildcardCompare(String pattern, int patIndex, int patEnd, CharSequence target) {
        int tarLen = target.length();
        int i = pattern.indexOf(42, patIndex);
        if (i < 0 || i >= patEnd) {
            return tarLen == patEnd - patIndex && Strings.wildcardCompareSubstring(pattern, patIndex, patEnd, target, 0);
        }
        if (i - patIndex > tarLen || !Strings.wildcardCompareSubstring(pattern, patIndex, i, target, 0)) {
            return false;
        }
        int tarIndex = i - patIndex;
        patIndex = i + 1;
        while ((i = pattern.indexOf(42, patIndex)) >= 0 && i < patEnd) {
            i -= patIndex;
            while (true) {
                if (tarIndex + i > tarLen) {
                    return false;
                }
                if (Strings.wildcardCompareSubstring(pattern, patIndex, patIndex + i, target, tarIndex)) break;
                ++tarIndex;
            }
            tarIndex += i;
            patIndex += i + 1;
        }
        i = tarLen - (patEnd - patIndex);
        return tarIndex <= i && Strings.wildcardCompareSubstring(pattern, patIndex, patEnd, target, i);
    }

    private static boolean wildcardCompareSubstring(String pattern, int patIndex, int patEnd, CharSequence target, int index) {
        while (patIndex < patEnd) {
            char ch = pattern.charAt(patIndex++);
            if (target.charAt(index++) == ch || ch == '?') continue;
            return false;
        }
        return true;
    }

    public static String trim(String s, IntPredicate test) {
        Objects.requireNonNull(test);
        int start = 0;
        int end = s.length();
        while (true) {
            if (start >= end) {
                return emptyString;
            }
            if (!test.test(s.charAt(start))) break;
            ++start;
        }
        while (test.test(s.charAt(end - 1))) {
            --end;
        }
        return start == 0 && end == s.length() ? s : s.substring(start, end);
    }

    public static String trimLeading(String s, IntPredicate test) {
        Objects.requireNonNull(test);
        int start = 0;
        int end = s.length();
        while (true) {
            if (start >= end) {
                return emptyString;
            }
            if (!test.test(s.charAt(start))) break;
            ++start;
        }
        return start == 0 ? s : s.substring(start);
    }

    public static String trimTrailing(String s, IntPredicate test) {
        Objects.requireNonNull(test);
        int end = s.length();
        while (true) {
            if (end <= 0) {
                return emptyString;
            }
            if (!test.test(s.charAt(end - 1))) break;
            --end;
        }
        return end == s.length() ? s : s.substring(0, end);
    }

    public static CharSequence trim(CharSequence cs, IntPredicate test) {
        Objects.requireNonNull(test);
        int start = 0;
        int end = cs.length();
        while (true) {
            if (start >= end) {
                return emptyString;
            }
            if (!test.test(cs.charAt(start))) break;
            ++start;
        }
        while (test.test(cs.charAt(end - 1))) {
            --end;
        }
        return start == 0 && end == cs.length() ? cs : new SubSequence(cs, start, end);
    }

    public static CharSequence trimLeading(CharSequence cs, IntPredicate test) {
        Objects.requireNonNull(test);
        int start = 0;
        int end = cs.length();
        while (true) {
            if (start >= end) {
                return emptyString;
            }
            if (!test.test(cs.charAt(start))) break;
            ++start;
        }
        return start == 0 ? cs : new SubSequence(cs, start, end);
    }

    public static CharSequence trimTrailing(CharSequence cs, IntPredicate test) {
        Objects.requireNonNull(test);
        int end = cs.length();
        while (true) {
            if (end <= 0) {
                return emptyString;
            }
            if (!test.test(cs.charAt(end - 1))) break;
            --end;
        }
        return end == cs.length() ? cs : new SubSequence(cs, 0, end);
    }

    public static String trim(String s) {
        return Strings.trim(s, Character::isWhitespace);
    }

    public static String trimLeading(String s) {
        return Strings.trimLeading(s, Character::isWhitespace);
    }

    public static String trimTrailing(String s) {
        return Strings.trimTrailing(s, Character::isWhitespace);
    }

    public static CharSequence trim(CharSequence cs) {
        return Strings.trim(cs, Character::isWhitespace);
    }

    public static CharSequence trimLeading(CharSequence cs) {
        return Strings.trimLeading(cs, Character::isWhitespace);
    }

    public static CharSequence trimTrailing(CharSequence cs) {
        return Strings.trimTrailing(cs, Character::isWhitespace);
    }

    public static String trimUTF16(String s, IntPredicate test) {
        Objects.requireNonNull(test);
        int start = 0;
        int end = s.length();
        while (true) {
            char lo;
            if (start >= end) {
                return emptyString;
            }
            char hi = s.charAt(start);
            if (Character.isHighSurrogate(hi) && start + 1 < end && Character.isLowSurrogate(lo = s.charAt(start + 1))) {
                if (!test.test(Character.toCodePoint(hi, lo))) break;
                start += 2;
                continue;
            }
            if (!test.test(hi)) break;
            ++start;
        }
        while (end > start) {
            char hi;
            char lo = s.charAt(end - 1);
            if (Character.isLowSurrogate(lo) && end - 1 > start && Character.isHighSurrogate(hi = s.charAt(end - 2))) {
                if (!test.test(Character.toCodePoint(hi, lo))) break;
                end -= 2;
                continue;
            }
            if (!test.test(lo)) break;
            --end;
        }
        return start == 0 && end == s.length() ? s : s.substring(start, end);
    }

    public static String strip(String s, IntPredicate test) {
        Objects.requireNonNull(test);
        int i = 0;
        int n = s.length();
        while (i < n) {
            if (!test.test(s.charAt(i++))) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(s, 0, i - 1);
            while (i < n) {
                char ch;
                if (test.test(ch = s.charAt(i++))) continue;
                sb.append(ch);
            }
            return sb.toString();
        }
        return s;
    }

    public static CharSequence strip(CharSequence cs, IntPredicate test) {
        Objects.requireNonNull(test);
        int i = 0;
        int n = cs.length();
        while (i < n) {
            if (!test.test(cs.charAt(i++))) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(cs, 0, i - 1);
            while (i < n) {
                char ch;
                if (test.test(ch = cs.charAt(i++))) continue;
                sb.append(ch);
            }
            return sb;
        }
        return cs;
    }

    public static String stripUTF16(String s, IntPredicate test) {
        Objects.requireNonNull(test);
        int i = 0;
        int n = s.length();
        while (i < n) {
            boolean stripped;
            char lo;
            char hi;
            int k = i;
            if (Character.isHighSurrogate(hi = s.charAt(i++)) && i < n && Character.isLowSurrogate(lo = s.charAt(i))) {
                stripped = test.test(Character.toCodePoint(hi, lo));
                ++i;
            } else {
                stripped = test.test(hi);
            }
            if (!stripped) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(s, 0, k);
            while (i < n) {
                if (Character.isHighSurrogate(hi = s.charAt(i++)) && i < n && Character.isLowSurrogate(lo = s.charAt(i))) {
                    if (!test.test(Character.toCodePoint(hi, lo))) {
                        sb.append(hi);
                        sb.append(lo);
                    }
                    ++i;
                    continue;
                }
                if (test.test(hi)) continue;
                sb.append(hi);
            }
            return sb.toString();
        }
        return s;
    }

    public static StringBuilder build() {
        return new StringBuilder();
    }

    public static StringBuilder build(CharSequence cs) {
        return new StringBuilder(cs);
    }

    public static String toIdentifier(int i) {
        StringBuilder sb = new StringBuilder();
        i = Math.abs(i);
        do {
            sb.insert(0, (char)(i % 26 + 65));
        } while ((i = i / 26 - 1) >= 0);
        return sb.toString();
    }

    public static void appendInt(Appendable a, int i) throws IOException {
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                a.append("-2147483648");
                return;
            }
            a.append('-');
            Strings.appendPositiveInt(a, -i);
        } else {
            Strings.appendPositiveInt(a, i);
        }
    }

    public static void appendPositiveInt(Appendable a, int i) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            Strings.appendPositiveInt(a, n);
            a.append(tensDigits[i -= n * 100]);
            a.append(digits[i]);
        } else if (i >= 10) {
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else {
            a.append(digits[i]);
        }
    }

    public static void appendLong(Appendable a, long n) throws IOException {
        if (n < 0L) {
            if (n == Long.MIN_VALUE) {
                a.append("-9223372036854775808");
                return;
            }
            a.append('-');
            Strings.appendPositiveLong(a, -n);
        } else {
            Strings.appendPositiveLong(a, n);
        }
    }

    public static void appendPositiveLong(Appendable a, long n) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            Strings.appendPositiveLong(a, m);
            int i = (int)(n - m * 100L);
            a.append(tensDigits[i]);
            a.append(digits[i]);
        } else if (n >= 10L) {
            a.append(tensDigits[(int)n]);
            a.append(digits[(int)n]);
        } else {
            a.append(digits[(int)n]);
        }
    }

    public static void append2Digits(Appendable a, int i) throws IOException {
        a.append(tensDigits[i]);
        a.append(digits[i]);
    }

    public static void append3Digits(Appendable a, int i) throws IOException {
        int n = i / 100;
        a.append(digits[n]);
        a.append(tensDigits[i -= n * 100]);
        a.append(digits[i]);
    }
}

