/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

public interface BaseAcceptor<R>
extends AutoCloseable {
    public boolean isClosed();

    default public R getResult() {
        throw new UnsupportedOperationException("No result defined");
    }

    default public boolean isComplete() {
        return true;
    }

    default public void flush() {
    }

    default public void safeClose() {
        try {
            this.close();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in close function", e);
        }
    }
}

