/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import net.pwall.pipeline.AbstractIntAcceptor;

public class ByteArrayAcceptor
extends AbstractIntAcceptor<byte[]> {
    public static final int DEFAULT_INITIAL_CAPACITY = 20;
    private byte[] byteArray;
    private int index;

    public ByteArrayAcceptor(int initialCapacity) {
        this.byteArray = new byte[initialCapacity];
        this.index = 0;
    }

    public ByteArrayAcceptor() {
        this(20);
    }

    @Override
    public void acceptInt(int value) {
        int len = this.byteArray.length;
        if (this.index >= len) {
            int newLen = len + Math.min(len, 4096);
            byte[] newArray = new byte[newLen];
            System.arraycopy(this.byteArray, 0, newArray, 0, this.index);
            this.byteArray = newArray;
        }
        this.byteArray[this.index++] = (byte)value;
    }

    @Override
    public byte[] getResult() {
        byte[] result = new byte[this.index];
        System.arraycopy(this.byteArray, 0, result, 0, this.index);
        return result;
    }

    public int length() {
        return this.index;
    }

    public void clear() {
        this.index = 0;
    }
}

