/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import net.pwall.pipeline.AbstractIntObjectPipeline;
import net.pwall.pipeline.Acceptor;

public class LinePipeline<R>
extends AbstractIntObjectPipeline<String, R> {
    private final int maxLength;
    private final StringBuilder line;
    private boolean crSeen;

    public LinePipeline(Acceptor<? super String, ? extends R> downstream, int maxLength) {
        super(downstream);
        this.maxLength = maxLength;
        this.line = new StringBuilder();
        this.crSeen = false;
    }

    public LinePipeline(Acceptor<? super String, ? extends R> downstream) {
        super(downstream);
        this.maxLength = -1;
        this.line = new StringBuilder();
        this.crSeen = false;
    }

    @Override
    public void acceptInt(int value) {
        if (value == 13) {
            this.emitLine();
            this.crSeen = true;
        } else if (value == 10) {
            if (!this.crSeen) {
                this.emitLine();
            }
            this.crSeen = false;
        } else {
            this.line.append((char)value);
            if (this.maxLength > 0 && this.line.length() >= this.maxLength) {
                this.emitLine();
            }
            this.crSeen = false;
        }
    }

    private void emitLine() {
        this.emit(this.line.length() == 0 ? "" : this.line.toString());
        this.line.setLength(0);
    }

    @Override
    public void close() {
        if (this.line.length() > 0) {
            this.emitLine();
        }
        this.getDownstream().safeClose();
    }
}

