/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.pwall.pipeline.AbstractAcceptor;

public class ListAcceptor<A>
extends AbstractAcceptor<A, List<A>> {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final List<A> list;

    public ListAcceptor(int initialCapacity) {
        this.list = new ArrayList<A>(initialCapacity);
    }

    public ListAcceptor() {
        this(10);
    }

    public ListAcceptor(List<A> list) {
        this.list = list;
    }

    @Override
    public void acceptObject(A value) {
        this.list.add(value);
    }

    @Override
    public List<A> getResult() {
        return Collections.unmodifiableList(this.list);
    }

    public int getSize() {
        return this.list.size();
    }
}

