/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.pwall.pipeline.Acceptor;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.util.IntOutput;

public class Pipelines {
    public static <R> R process(Reader reader, IntAcceptor<R> downstream) throws IOException {
        int i;
        do {
            i = reader.read();
            downstream.accept(i);
        } while (i >= 0);
        return downstream.getResult();
    }

    public static <R> R process(InputStream inputStream, IntAcceptor<R> downstream) throws IOException {
        int i;
        do {
            i = inputStream.read();
            downstream.accept(i);
        } while (i >= 0);
        return downstream.getResult();
    }

    public static <R> R process(File file, IntAcceptor<R> downstream) throws IOException {
        return Pipelines.process(new FileInputStream(file), downstream);
    }

    public static <A, R> R process(Iterable<A> iterable, Acceptor<A, R> downstream) {
        for (A item : iterable) {
            downstream.accept(item);
        }
        downstream.safeClose();
        return downstream.getResult();
    }

    public static void acceptInt(IntAcceptor<?> acceptor, int i) {
        IntOutput.outputInt((int)i, acceptor);
    }
}

