/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.pwall.pipeline.AbstractAcceptor;

public class SetAcceptor<A>
extends AbstractAcceptor<A, Set<A>> {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Set<A> set;

    public SetAcceptor(int initialCapacity) {
        this.set = new HashSet<A>(initialCapacity);
    }

    public SetAcceptor() {
        this(10);
    }

    public SetAcceptor(Set<A> set) {
        this.set = set;
    }

    @Override
    public void acceptObject(A value) {
        this.set.add(value);
    }

    @Override
    public Set<A> getResult() {
        return Collections.unmodifiableSet(this.set);
    }

    public int getSize() {
        return this.set.size();
    }
}

