/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.base64;

import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.codec.ErrorStrategy;
import net.pwall.pipeline.codec.ErrorStrategyBase;

public class Base64Encoder<R>
extends ErrorStrategyBase<R> {
    public static final byte[] encodingArrayMain;
    public static final byte[] encodingArrayURL;
    private final byte[] encodingArray;
    private final boolean urlSafe;
    private State state = State.FIRST;
    private int saved;

    public Base64Encoder(IntAcceptor<? extends R> downstream, boolean urlSafe, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
        this.encodingArray = urlSafe ? encodingArrayURL : encodingArrayMain;
        this.urlSafe = urlSafe;
    }

    public Base64Encoder(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        this(downstream, false, errorStrategy);
    }

    public Base64Encoder(IntAcceptor<? extends R> downstream, boolean urlSafe) {
        this(downstream, urlSafe, ErrorStrategy.DEFAULT);
    }

    public Base64Encoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false, ErrorStrategy.DEFAULT);
    }

    @Override
    public void acceptInt(int value) {
        if (value > 255) {
            this.handleError(value);
            return;
        }
        switch (this.state) {
            case FIRST: {
                this.emit(this.encodingArray[value >> 2 & 0x3F]);
                this.saved = value;
                this.state = State.SECOND;
                break;
            }
            case SECOND: {
                this.emit(this.encodingArray[this.saved << 4 & 0x30 | value >> 4 & 0xF]);
                this.saved = value;
                this.state = State.THIRD;
                break;
            }
            case THIRD: {
                this.emit(this.encodingArray[this.saved << 2 & 0x3C | value >> 6 & 3]);
                this.emit(this.encodingArray[value & 0x3F]);
                this.state = State.FIRST;
            }
        }
    }

    @Override
    public void close() {
        switch (this.state) {
            case FIRST: {
                break;
            }
            case SECOND: {
                this.emit(this.encodingArray[this.saved << 4 & 0x30]);
                if (this.urlSafe) break;
                this.emit(61);
                this.emit(61);
                break;
            }
            case THIRD: {
                this.emit(this.encodingArray[this.saved << 2 & 0x3C]);
                if (this.urlSafe) break;
                this.emit(61);
            }
        }
    }

    static {
        int i;
        encodingArrayMain = new byte[64];
        encodingArrayURL = new byte[64];
        for (i = 0; i < 26; ++i) {
            Base64Encoder.encodingArrayMain[i] = (byte)(65 + i);
            Base64Encoder.encodingArrayURL[i] = (byte)(65 + i);
        }
        for (i = 0; i < 26; ++i) {
            Base64Encoder.encodingArrayMain[i + 26] = (byte)(97 + i);
            Base64Encoder.encodingArrayURL[i + 26] = (byte)(97 + i);
        }
        for (i = 0; i < 10; ++i) {
            Base64Encoder.encodingArrayMain[i + 52] = (byte)(48 + i);
            Base64Encoder.encodingArrayURL[i + 52] = (byte)(48 + i);
        }
        Base64Encoder.encodingArrayMain[62] = 43;
        Base64Encoder.encodingArrayURL[62] = 45;
        Base64Encoder.encodingArrayMain[63] = 47;
        Base64Encoder.encodingArrayURL[63] = 95;
    }

    public static enum State {
        FIRST,
        SECOND,
        THIRD;

    }
}

