/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.buffer;

import net.pwall.pipeline.AbstractObjectIntPipeline;
import net.pwall.pipeline.IntAcceptor;

public class ByteArrayPipeline<R>
extends AbstractObjectIntPipeline<byte[], R> {
    public ByteArrayPipeline(IntAcceptor<? extends R> downstream) {
        super(downstream);
    }

    @Override
    public void acceptObject(byte[] value) {
        for (byte b : value) {
            this.emit(b);
        }
    }

    public void accept(byte[] value, int offset, int length) {
        if (this.isClosed()) {
            throw new IllegalStateException("Acceptor is closed");
        }
        if (value == null) {
            this.safeClose();
        } else {
            this.acceptObject(value, offset, length);
        }
    }

    public void acceptObject(byte[] value, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            this.emit(value[i]);
        }
    }
}

