/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.codec;

import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.codec.ErrorStrategy;
import net.pwall.pipeline.codec.ErrorStrategyBase;

public class CodePoint_UTF8<R>
extends ErrorStrategyBase<R> {
    public CodePoint_UTF8(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public CodePoint_UTF8(IntAcceptor<? extends R> downstream) {
        super(downstream, ErrorStrategy.THROW_EXCEPTION);
    }

    @Override
    public void acceptInt(int value) {
        if (value <= 127) {
            this.emit(value);
        } else if (value <= 2047) {
            this.emit(0xC0 | value >> 6);
            this.emit(0x80 | value & 0x3F);
        } else if (value <= 65535) {
            this.emit(0xE0 | value >> 12);
            this.emit(0x80 | value >> 6 & 0x3F);
            this.emit(0x80 | value & 0x3F);
        } else if (value <= 0x10FFFF) {
            this.emit(0xF0 | value >> 18);
            this.emit(0x80 | value >> 12 & 0x3F);
            this.emit(0x80 | value >> 6 & 0x3F);
            this.emit(0x80 | value & 0x3F);
        } else {
            this.handleError(value);
        }
    }
}

