/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.codec;

import java.nio.charset.Charset;
import net.pwall.pipeline.AbstractIntPipeline;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.codec.CodePoint_UTF8;
import net.pwall.pipeline.codec.ErrorStrategy;
import net.pwall.pipeline.codec.UTF16_ASCII;
import net.pwall.pipeline.codec.UTF16_ISO8859_1;
import net.pwall.pipeline.codec.UTF16_ISO8859_15;
import net.pwall.pipeline.codec.UTF16_Windows1252;

public class EncoderFactory {
    public static <R> AbstractIntPipeline<R> getEncoder(String charsetName, IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        if (charsetName.equalsIgnoreCase("windows-1252")) {
            return new UTF16_Windows1252<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("ISO-8859-1")) {
            return new UTF16_ISO8859_1<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("ISO-8859-15")) {
            return new UTF16_ISO8859_15<R>(downstream, errorStrategy);
        }
        if (charsetName.equalsIgnoreCase("US-ASCII")) {
            return new UTF16_ASCII<R>(downstream, errorStrategy);
        }
        return new CodePoint_UTF8<R>(downstream, errorStrategy);
    }

    public static <R> AbstractIntPipeline<R> getEncoder(String charsetName, IntAcceptor<? extends R> downstream) {
        return EncoderFactory.getEncoder(charsetName, downstream, ErrorStrategy.DEFAULT);
    }

    public static <R> AbstractIntPipeline<R> getEncoder(Charset charset, IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        return EncoderFactory.getEncoder(charset.name(), downstream, errorStrategy);
    }

    public static <R> AbstractIntPipeline<R> getEncoder(Charset charset, IntAcceptor<? extends R> downstream) {
        return EncoderFactory.getEncoder(charset.name(), downstream, ErrorStrategy.DEFAULT);
    }
}

