/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.pipeline.html;

import java.util.ArrayList;
import java.util.Arrays;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.html.HTMLEncoder;
import net.pwall.pipeline.xxml.DecoderBase;
import net.pwall.pipeline.xxml.MappingEntry;

public class HTMLDecoder<R>
extends DecoderBase<R> {
    public static final MappingEntry[] reverseTable;

    public HTMLDecoder(IntAcceptor<? extends R> downstream) {
        super(reverseTable, downstream);
    }

    static {
        int baseEntitiesLength = HTMLEncoder.baseEntities.length;
        int mappedEntitiesLength = HTMLEncoder.mappedEntities.length;
        ArrayList<MappingEntry> list = new ArrayList<MappingEntry>(baseEntitiesLength + mappedEntitiesLength + 4);
        list.add(new MappingEntry(34, "quot"));
        list.add(new MappingEntry(38, "amp"));
        list.add(new MappingEntry(60, "lt"));
        list.add(new MappingEntry(62, "gt"));
        for (int i = 0; i < baseEntitiesLength; ++i) {
            list.add(new MappingEntry(i + 160, HTMLEncoder.baseEntities[i]));
        }
        list.addAll(Arrays.asList(HTMLEncoder.mappedEntities));
        reverseTable = list.toArray(new MappingEntry[0]);
        Arrays.sort(reverseTable);
    }
}

